/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.mediaservices.model.StreamCdnConfigSection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class AkamaiManualStreamCdnConfig
extends StreamCdnConfigSection {
    @JsonProperty(value="originAuthSignType")
    private final OriginAuthSignType originAuthSignType;
    @JsonProperty(value="originAuthSignEncryption")
    private final OriginAuthSignEncryption originAuthSignEncryption;
    @JsonProperty(value="originAuthSecretKeyA")
    private final String originAuthSecretKeyA;
    @JsonProperty(value="originAuthSecretKeyNonceA")
    private final String originAuthSecretKeyNonceA;
    @JsonProperty(value="originAuthSecretKeyB")
    private final String originAuthSecretKeyB;
    @JsonProperty(value="originAuthSecretKeyNonceB")
    private final String originAuthSecretKeyNonceB;
    @JsonProperty(value="edgeHostname")
    private final String edgeHostname;
    @JsonProperty(value="edgePathPrefix")
    private final String edgePathPrefix;
    @JsonProperty(value="isEdgeTokenAuth")
    private final Boolean isEdgeTokenAuth;
    @JsonProperty(value="edgeTokenKey")
    private final String edgeTokenKey;
    @JsonProperty(value="edgeTokenSalt")
    private final String edgeTokenSalt;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AkamaiManualStreamCdnConfig(OriginAuthSignType originAuthSignType, OriginAuthSignEncryption originAuthSignEncryption, String originAuthSecretKeyA, String originAuthSecretKeyNonceA, String originAuthSecretKeyB, String originAuthSecretKeyNonceB, String edgeHostname, String edgePathPrefix, Boolean isEdgeTokenAuth, String edgeTokenKey, String edgeTokenSalt) {
        this.originAuthSignType = originAuthSignType;
        this.originAuthSignEncryption = originAuthSignEncryption;
        this.originAuthSecretKeyA = originAuthSecretKeyA;
        this.originAuthSecretKeyNonceA = originAuthSecretKeyNonceA;
        this.originAuthSecretKeyB = originAuthSecretKeyB;
        this.originAuthSecretKeyNonceB = originAuthSecretKeyNonceB;
        this.edgeHostname = edgeHostname;
        this.edgePathPrefix = edgePathPrefix;
        this.isEdgeTokenAuth = isEdgeTokenAuth;
        this.edgeTokenKey = edgeTokenKey;
        this.edgeTokenSalt = edgeTokenSalt;
    }

    public OriginAuthSignType getOriginAuthSignType() {
        return this.originAuthSignType;
    }

    public OriginAuthSignEncryption getOriginAuthSignEncryption() {
        return this.originAuthSignEncryption;
    }

    public String getOriginAuthSecretKeyA() {
        return this.originAuthSecretKeyA;
    }

    public String getOriginAuthSecretKeyNonceA() {
        return this.originAuthSecretKeyNonceA;
    }

    public String getOriginAuthSecretKeyB() {
        return this.originAuthSecretKeyB;
    }

    public String getOriginAuthSecretKeyNonceB() {
        return this.originAuthSecretKeyNonceB;
    }

    public String getEdgeHostname() {
        return this.edgeHostname;
    }

    public String getEdgePathPrefix() {
        return this.edgePathPrefix;
    }

    public Boolean getIsEdgeTokenAuth() {
        return this.isEdgeTokenAuth;
    }

    public String getEdgeTokenKey() {
        return this.edgeTokenKey;
    }

    public String getEdgeTokenSalt() {
        return this.edgeTokenSalt;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AkamaiManualStreamCdnConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", originAuthSignType=").append(String.valueOf((Object)this.originAuthSignType));
        sb.append(", originAuthSignEncryption=").append(String.valueOf((Object)this.originAuthSignEncryption));
        sb.append(", originAuthSecretKeyA=").append(String.valueOf(this.originAuthSecretKeyA));
        sb.append(", originAuthSecretKeyNonceA=").append(String.valueOf(this.originAuthSecretKeyNonceA));
        sb.append(", originAuthSecretKeyB=").append(String.valueOf(this.originAuthSecretKeyB));
        sb.append(", originAuthSecretKeyNonceB=").append(String.valueOf(this.originAuthSecretKeyNonceB));
        sb.append(", edgeHostname=").append(String.valueOf(this.edgeHostname));
        sb.append(", edgePathPrefix=").append(String.valueOf(this.edgePathPrefix));
        sb.append(", isEdgeTokenAuth=").append(String.valueOf(this.isEdgeTokenAuth));
        sb.append(", edgeTokenKey=").append(String.valueOf(this.edgeTokenKey));
        sb.append(", edgeTokenSalt=").append(String.valueOf(this.edgeTokenSalt));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AkamaiManualStreamCdnConfig)) {
            return false;
        }
        AkamaiManualStreamCdnConfig other = (AkamaiManualStreamCdnConfig)((Object)o);
        return Objects.equals((Object)this.originAuthSignType, (Object)other.originAuthSignType) && Objects.equals((Object)this.originAuthSignEncryption, (Object)other.originAuthSignEncryption) && Objects.equals(this.originAuthSecretKeyA, other.originAuthSecretKeyA) && Objects.equals(this.originAuthSecretKeyNonceA, other.originAuthSecretKeyNonceA) && Objects.equals(this.originAuthSecretKeyB, other.originAuthSecretKeyB) && Objects.equals(this.originAuthSecretKeyNonceB, other.originAuthSecretKeyNonceB) && Objects.equals(this.edgeHostname, other.edgeHostname) && Objects.equals(this.edgePathPrefix, other.edgePathPrefix) && Objects.equals(this.isEdgeTokenAuth, other.isEdgeTokenAuth) && Objects.equals(this.edgeTokenKey, other.edgeTokenKey) && Objects.equals(this.edgeTokenSalt, other.edgeTokenSalt) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.originAuthSignType == null ? 43 : this.originAuthSignType.hashCode());
        result = result * 59 + (this.originAuthSignEncryption == null ? 43 : this.originAuthSignEncryption.hashCode());
        result = result * 59 + (this.originAuthSecretKeyA == null ? 43 : this.originAuthSecretKeyA.hashCode());
        result = result * 59 + (this.originAuthSecretKeyNonceA == null ? 43 : this.originAuthSecretKeyNonceA.hashCode());
        result = result * 59 + (this.originAuthSecretKeyB == null ? 43 : this.originAuthSecretKeyB.hashCode());
        result = result * 59 + (this.originAuthSecretKeyNonceB == null ? 43 : this.originAuthSecretKeyNonceB.hashCode());
        result = result * 59 + (this.edgeHostname == null ? 43 : this.edgeHostname.hashCode());
        result = result * 59 + (this.edgePathPrefix == null ? 43 : this.edgePathPrefix.hashCode());
        result = result * 59 + (this.isEdgeTokenAuth == null ? 43 : this.isEdgeTokenAuth.hashCode());
        result = result * 59 + (this.edgeTokenKey == null ? 43 : this.edgeTokenKey.hashCode());
        result = result * 59 + (this.edgeTokenSalt == null ? 43 : this.edgeTokenSalt.hashCode());
        return result;
    }

    public static enum OriginAuthSignEncryption implements BmcEnum
    {
        Sha256Hmac("SHA256-HMAC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OriginAuthSignEncryption> map;

        private OriginAuthSignEncryption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OriginAuthSignEncryption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OriginAuthSignEncryption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OriginAuthSignEncryption.class);
            map = new HashMap<String, OriginAuthSignEncryption>();
            for (OriginAuthSignEncryption v : OriginAuthSignEncryption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OriginAuthSignType implements BmcEnum
    {
        ForwardUrl("ForwardURL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OriginAuthSignType> map;

        private OriginAuthSignType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OriginAuthSignType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OriginAuthSignType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OriginAuthSignType.class);
            map = new HashMap<String, OriginAuthSignType>();
            for (OriginAuthSignType v : OriginAuthSignType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="originAuthSignType")
        private OriginAuthSignType originAuthSignType;
        @JsonProperty(value="originAuthSignEncryption")
        private OriginAuthSignEncryption originAuthSignEncryption;
        @JsonProperty(value="originAuthSecretKeyA")
        private String originAuthSecretKeyA;
        @JsonProperty(value="originAuthSecretKeyNonceA")
        private String originAuthSecretKeyNonceA;
        @JsonProperty(value="originAuthSecretKeyB")
        private String originAuthSecretKeyB;
        @JsonProperty(value="originAuthSecretKeyNonceB")
        private String originAuthSecretKeyNonceB;
        @JsonProperty(value="edgeHostname")
        private String edgeHostname;
        @JsonProperty(value="edgePathPrefix")
        private String edgePathPrefix;
        @JsonProperty(value="isEdgeTokenAuth")
        private Boolean isEdgeTokenAuth;
        @JsonProperty(value="edgeTokenKey")
        private String edgeTokenKey;
        @JsonProperty(value="edgeTokenSalt")
        private String edgeTokenSalt;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder originAuthSignType(OriginAuthSignType originAuthSignType) {
            this.originAuthSignType = originAuthSignType;
            this.__explicitlySet__.add("originAuthSignType");
            return this;
        }

        public Builder originAuthSignEncryption(OriginAuthSignEncryption originAuthSignEncryption) {
            this.originAuthSignEncryption = originAuthSignEncryption;
            this.__explicitlySet__.add("originAuthSignEncryption");
            return this;
        }

        public Builder originAuthSecretKeyA(String originAuthSecretKeyA) {
            this.originAuthSecretKeyA = originAuthSecretKeyA;
            this.__explicitlySet__.add("originAuthSecretKeyA");
            return this;
        }

        public Builder originAuthSecretKeyNonceA(String originAuthSecretKeyNonceA) {
            this.originAuthSecretKeyNonceA = originAuthSecretKeyNonceA;
            this.__explicitlySet__.add("originAuthSecretKeyNonceA");
            return this;
        }

        public Builder originAuthSecretKeyB(String originAuthSecretKeyB) {
            this.originAuthSecretKeyB = originAuthSecretKeyB;
            this.__explicitlySet__.add("originAuthSecretKeyB");
            return this;
        }

        public Builder originAuthSecretKeyNonceB(String originAuthSecretKeyNonceB) {
            this.originAuthSecretKeyNonceB = originAuthSecretKeyNonceB;
            this.__explicitlySet__.add("originAuthSecretKeyNonceB");
            return this;
        }

        public Builder edgeHostname(String edgeHostname) {
            this.edgeHostname = edgeHostname;
            this.__explicitlySet__.add("edgeHostname");
            return this;
        }

        public Builder edgePathPrefix(String edgePathPrefix) {
            this.edgePathPrefix = edgePathPrefix;
            this.__explicitlySet__.add("edgePathPrefix");
            return this;
        }

        public Builder isEdgeTokenAuth(Boolean isEdgeTokenAuth) {
            this.isEdgeTokenAuth = isEdgeTokenAuth;
            this.__explicitlySet__.add("isEdgeTokenAuth");
            return this;
        }

        public Builder edgeTokenKey(String edgeTokenKey) {
            this.edgeTokenKey = edgeTokenKey;
            this.__explicitlySet__.add("edgeTokenKey");
            return this;
        }

        public Builder edgeTokenSalt(String edgeTokenSalt) {
            this.edgeTokenSalt = edgeTokenSalt;
            this.__explicitlySet__.add("edgeTokenSalt");
            return this;
        }

        public AkamaiManualStreamCdnConfig build() {
            AkamaiManualStreamCdnConfig model = new AkamaiManualStreamCdnConfig(this.originAuthSignType, this.originAuthSignEncryption, this.originAuthSecretKeyA, this.originAuthSecretKeyNonceA, this.originAuthSecretKeyB, this.originAuthSecretKeyNonceB, this.edgeHostname, this.edgePathPrefix, this.isEdgeTokenAuth, this.edgeTokenKey, this.edgeTokenSalt);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AkamaiManualStreamCdnConfig model) {
            if (model.wasPropertyExplicitlySet("originAuthSignType")) {
                this.originAuthSignType(model.getOriginAuthSignType());
            }
            if (model.wasPropertyExplicitlySet("originAuthSignEncryption")) {
                this.originAuthSignEncryption(model.getOriginAuthSignEncryption());
            }
            if (model.wasPropertyExplicitlySet("originAuthSecretKeyA")) {
                this.originAuthSecretKeyA(model.getOriginAuthSecretKeyA());
            }
            if (model.wasPropertyExplicitlySet("originAuthSecretKeyNonceA")) {
                this.originAuthSecretKeyNonceA(model.getOriginAuthSecretKeyNonceA());
            }
            if (model.wasPropertyExplicitlySet("originAuthSecretKeyB")) {
                this.originAuthSecretKeyB(model.getOriginAuthSecretKeyB());
            }
            if (model.wasPropertyExplicitlySet("originAuthSecretKeyNonceB")) {
                this.originAuthSecretKeyNonceB(model.getOriginAuthSecretKeyNonceB());
            }
            if (model.wasPropertyExplicitlySet("edgeHostname")) {
                this.edgeHostname(model.getEdgeHostname());
            }
            if (model.wasPropertyExplicitlySet("edgePathPrefix")) {
                this.edgePathPrefix(model.getEdgePathPrefix());
            }
            if (model.wasPropertyExplicitlySet("isEdgeTokenAuth")) {
                this.isEdgeTokenAuth(model.getIsEdgeTokenAuth());
            }
            if (model.wasPropertyExplicitlySet("edgeTokenKey")) {
                this.edgeTokenKey(model.getEdgeTokenKey());
            }
            if (model.wasPropertyExplicitlySet("edgeTokenSalt")) {
                this.edgeTokenSalt(model.getEdgeTokenSalt());
            }
            return this;
        }
    }
}

