/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mediaservices.MediaStreamAsync;
import com.oracle.bmc.mediaservices.model.SessionToken;
import com.oracle.bmc.mediaservices.requests.GeneratePlaylistRequest;
import com.oracle.bmc.mediaservices.requests.GenerateSessionTokenRequest;
import com.oracle.bmc.mediaservices.responses.GeneratePlaylistResponse;
import com.oracle.bmc.mediaservices.responses.GenerateSessionTokenResponse;
import com.oracle.bmc.responses.AsyncHandler;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaStreamAsyncClient
extends BaseAsyncClient
implements MediaStreamAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MEDIASTREAM").serviceEndpointPrefix("").serviceEndpointTemplate("https://mediaservices.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(MediaStreamAsyncClient.class);

    private MediaStreamAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GeneratePlaylistResponse> generatePlaylist(GeneratePlaylistRequest request, AsyncHandler<GeneratePlaylistRequest, GeneratePlaylistResponse> handler) {
        Objects.requireNonNull(request.getStreamPackagingConfigId(), "streamPackagingConfigId is required");
        Objects.requireNonNull(request.getMediaAssetId(), "mediaAssetId is required");
        return this.clientCall(request, GeneratePlaylistResponse::builder).logger(LOG, "generatePlaylist").serviceDetails("MediaStream", "GeneratePlaylist", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/GeneratePlaylist").method(Method.GET).requestBuilder(GeneratePlaylistRequest::builder).basePath("/20211101").appendPathParam("actions").appendPathParam("generatePlaylist").appendQueryParam("streamPackagingConfigId", (Object)request.getStreamPackagingConfigId()).appendQueryParam("mediaAssetId", (Object)request.getMediaAssetId()).appendQueryParam("token", (Object)request.getToken()).accept(new String[]{"application/x-mpegurl", "application/dash+xml"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GeneratePlaylistResponse.Builder::inputStream).handleResponseHeaderString("etag", GeneratePlaylistResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GeneratePlaylistResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateSessionTokenResponse> generateSessionToken(GenerateSessionTokenRequest request, AsyncHandler<GenerateSessionTokenRequest, GenerateSessionTokenResponse> handler) {
        Objects.requireNonNull(request.getGenerateSessionTokenDetails(), "generateSessionTokenDetails is required");
        return this.clientCall(request, GenerateSessionTokenResponse::builder).logger(LOG, "generateSessionToken").serviceDetails("MediaStream", "GenerateSessionToken", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/GenerateSessionToken").method(Method.POST).requestBuilder(GenerateSessionTokenRequest::builder).basePath("/20211101").appendPathParam("actions").appendPathParam("generateSessionToken").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SessionToken.class, GenerateSessionTokenResponse.Builder::sessionToken).handleResponseHeaderString("etag", GenerateSessionTokenResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GenerateSessionTokenResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public MediaStreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)MediaStreamAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public MediaStreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(MediaStreamAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public MediaStreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)MediaStreamAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public MediaStreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)MediaStreamAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public MediaStreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)MediaStreamAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public MediaStreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)MediaStreamAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public MediaStreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MediaStreamAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MediaStreamAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public MediaStreamAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new MediaStreamAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

