/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.mediaservices.MediaServices;
import com.oracle.bmc.mediaservices.MediaServicesAsyncClient;
import com.oracle.bmc.mediaservices.MediaServicesPaginators;
import com.oracle.bmc.mediaservices.MediaServicesWaiters;
import com.oracle.bmc.mediaservices.model.IngestStreamDistributionChannelResult;
import com.oracle.bmc.mediaservices.model.MediaAsset;
import com.oracle.bmc.mediaservices.model.MediaAssetCollection;
import com.oracle.bmc.mediaservices.model.MediaAssetDistributionChannelAttachment;
import com.oracle.bmc.mediaservices.model.MediaAssetDistributionChannelAttachmentCollection;
import com.oracle.bmc.mediaservices.model.MediaWorkflow;
import com.oracle.bmc.mediaservices.model.MediaWorkflowCollection;
import com.oracle.bmc.mediaservices.model.MediaWorkflowConfiguration;
import com.oracle.bmc.mediaservices.model.MediaWorkflowConfigurationCollection;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJob;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobCollection;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobFact;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobFactCollection;
import com.oracle.bmc.mediaservices.model.MediaWorkflowTaskDeclarationCollection;
import com.oracle.bmc.mediaservices.model.StreamCdnConfig;
import com.oracle.bmc.mediaservices.model.StreamCdnConfigCollection;
import com.oracle.bmc.mediaservices.model.StreamDistributionChannel;
import com.oracle.bmc.mediaservices.model.StreamDistributionChannelCollection;
import com.oracle.bmc.mediaservices.model.StreamPackagingConfig;
import com.oracle.bmc.mediaservices.model.StreamPackagingConfigCollection;
import com.oracle.bmc.mediaservices.model.SystemMediaWorkflowCollection;
import com.oracle.bmc.mediaservices.requests.ChangeMediaAssetCompartmentRequest;
import com.oracle.bmc.mediaservices.requests.ChangeMediaWorkflowCompartmentRequest;
import com.oracle.bmc.mediaservices.requests.ChangeMediaWorkflowConfigurationCompartmentRequest;
import com.oracle.bmc.mediaservices.requests.ChangeMediaWorkflowJobCompartmentRequest;
import com.oracle.bmc.mediaservices.requests.ChangeStreamDistributionChannelCompartmentRequest;
import com.oracle.bmc.mediaservices.requests.CreateMediaAssetRequest;
import com.oracle.bmc.mediaservices.requests.CreateMediaWorkflowConfigurationRequest;
import com.oracle.bmc.mediaservices.requests.CreateMediaWorkflowJobRequest;
import com.oracle.bmc.mediaservices.requests.CreateMediaWorkflowRequest;
import com.oracle.bmc.mediaservices.requests.CreateStreamCdnConfigRequest;
import com.oracle.bmc.mediaservices.requests.CreateStreamDistributionChannelRequest;
import com.oracle.bmc.mediaservices.requests.CreateStreamPackagingConfigRequest;
import com.oracle.bmc.mediaservices.requests.DeleteMediaAssetDistributionChannelAttachmentRequest;
import com.oracle.bmc.mediaservices.requests.DeleteMediaAssetRequest;
import com.oracle.bmc.mediaservices.requests.DeleteMediaWorkflowConfigurationRequest;
import com.oracle.bmc.mediaservices.requests.DeleteMediaWorkflowJobRequest;
import com.oracle.bmc.mediaservices.requests.DeleteMediaWorkflowRequest;
import com.oracle.bmc.mediaservices.requests.DeleteStreamCdnConfigRequest;
import com.oracle.bmc.mediaservices.requests.DeleteStreamDistributionChannelRequest;
import com.oracle.bmc.mediaservices.requests.DeleteStreamPackagingConfigRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaAssetDistributionChannelAttachmentRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaAssetRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowConfigurationRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowJobFactRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowJobRequest;
import com.oracle.bmc.mediaservices.requests.GetMediaWorkflowRequest;
import com.oracle.bmc.mediaservices.requests.GetStreamCdnConfigRequest;
import com.oracle.bmc.mediaservices.requests.GetStreamDistributionChannelRequest;
import com.oracle.bmc.mediaservices.requests.GetStreamPackagingConfigRequest;
import com.oracle.bmc.mediaservices.requests.IngestStreamDistributionChannelRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaAssetDistributionChannelAttachmentsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaAssetsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowConfigurationsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowJobFactsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowJobsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowTaskDeclarationsRequest;
import com.oracle.bmc.mediaservices.requests.ListMediaWorkflowsRequest;
import com.oracle.bmc.mediaservices.requests.ListStreamCdnConfigsRequest;
import com.oracle.bmc.mediaservices.requests.ListStreamDistributionChannelsRequest;
import com.oracle.bmc.mediaservices.requests.ListStreamPackagingConfigsRequest;
import com.oracle.bmc.mediaservices.requests.ListSystemMediaWorkflowsRequest;
import com.oracle.bmc.mediaservices.requests.UpdateMediaAssetRequest;
import com.oracle.bmc.mediaservices.requests.UpdateMediaWorkflowConfigurationRequest;
import com.oracle.bmc.mediaservices.requests.UpdateMediaWorkflowJobRequest;
import com.oracle.bmc.mediaservices.requests.UpdateMediaWorkflowRequest;
import com.oracle.bmc.mediaservices.requests.UpdateStreamCdnConfigRequest;
import com.oracle.bmc.mediaservices.requests.UpdateStreamDistributionChannelRequest;
import com.oracle.bmc.mediaservices.requests.UpdateStreamPackagingConfigRequest;
import com.oracle.bmc.mediaservices.responses.ChangeMediaAssetCompartmentResponse;
import com.oracle.bmc.mediaservices.responses.ChangeMediaWorkflowCompartmentResponse;
import com.oracle.bmc.mediaservices.responses.ChangeMediaWorkflowConfigurationCompartmentResponse;
import com.oracle.bmc.mediaservices.responses.ChangeMediaWorkflowJobCompartmentResponse;
import com.oracle.bmc.mediaservices.responses.ChangeStreamDistributionChannelCompartmentResponse;
import com.oracle.bmc.mediaservices.responses.CreateMediaAssetResponse;
import com.oracle.bmc.mediaservices.responses.CreateMediaWorkflowConfigurationResponse;
import com.oracle.bmc.mediaservices.responses.CreateMediaWorkflowJobResponse;
import com.oracle.bmc.mediaservices.responses.CreateMediaWorkflowResponse;
import com.oracle.bmc.mediaservices.responses.CreateStreamCdnConfigResponse;
import com.oracle.bmc.mediaservices.responses.CreateStreamDistributionChannelResponse;
import com.oracle.bmc.mediaservices.responses.CreateStreamPackagingConfigResponse;
import com.oracle.bmc.mediaservices.responses.DeleteMediaAssetDistributionChannelAttachmentResponse;
import com.oracle.bmc.mediaservices.responses.DeleteMediaAssetResponse;
import com.oracle.bmc.mediaservices.responses.DeleteMediaWorkflowConfigurationResponse;
import com.oracle.bmc.mediaservices.responses.DeleteMediaWorkflowJobResponse;
import com.oracle.bmc.mediaservices.responses.DeleteMediaWorkflowResponse;
import com.oracle.bmc.mediaservices.responses.DeleteStreamCdnConfigResponse;
import com.oracle.bmc.mediaservices.responses.DeleteStreamDistributionChannelResponse;
import com.oracle.bmc.mediaservices.responses.DeleteStreamPackagingConfigResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaAssetDistributionChannelAttachmentResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaAssetResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowConfigurationResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowJobFactResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowJobResponse;
import com.oracle.bmc.mediaservices.responses.GetMediaWorkflowResponse;
import com.oracle.bmc.mediaservices.responses.GetStreamCdnConfigResponse;
import com.oracle.bmc.mediaservices.responses.GetStreamDistributionChannelResponse;
import com.oracle.bmc.mediaservices.responses.GetStreamPackagingConfigResponse;
import com.oracle.bmc.mediaservices.responses.IngestStreamDistributionChannelResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaAssetDistributionChannelAttachmentsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaAssetsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowConfigurationsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowJobFactsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowJobsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowTaskDeclarationsResponse;
import com.oracle.bmc.mediaservices.responses.ListMediaWorkflowsResponse;
import com.oracle.bmc.mediaservices.responses.ListStreamCdnConfigsResponse;
import com.oracle.bmc.mediaservices.responses.ListStreamDistributionChannelsResponse;
import com.oracle.bmc.mediaservices.responses.ListStreamPackagingConfigsResponse;
import com.oracle.bmc.mediaservices.responses.ListSystemMediaWorkflowsResponse;
import com.oracle.bmc.mediaservices.responses.UpdateMediaAssetResponse;
import com.oracle.bmc.mediaservices.responses.UpdateMediaWorkflowConfigurationResponse;
import com.oracle.bmc.mediaservices.responses.UpdateMediaWorkflowJobResponse;
import com.oracle.bmc.mediaservices.responses.UpdateMediaWorkflowResponse;
import com.oracle.bmc.mediaservices.responses.UpdateStreamCdnConfigResponse;
import com.oracle.bmc.mediaservices.responses.UpdateStreamDistributionChannelResponse;
import com.oracle.bmc.mediaservices.responses.UpdateStreamPackagingConfigResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaServicesClient
extends BaseSyncClient
implements MediaServices {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MEDIASERVICES").serviceEndpointPrefix("").serviceEndpointTemplate("https://mediaservices.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(MediaServicesAsyncClient.class);
    private final MediaServicesWaiters waiters;
    private final MediaServicesPaginators paginators;

    private MediaServicesClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("MediaServices-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new MediaServicesWaiters(executorService, this);
        this.paginators = new MediaServicesPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeMediaAssetCompartmentResponse changeMediaAssetCompartment(ChangeMediaAssetCompartmentRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMediaAssetCompartmentDetails(), "changeMediaAssetCompartmentDetails is required");
        return (ChangeMediaAssetCompartmentResponse)this.clientCall(request, ChangeMediaAssetCompartmentResponse::builder).logger(LOG, "changeMediaAssetCompartment").serviceDetails("MediaServices", "ChangeMediaAssetCompartment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAsset/ChangeMediaAssetCompartment").method(Method.POST).requestBuilder(ChangeMediaAssetCompartmentRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeMediaAssetCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeMediaWorkflowCompartmentResponse changeMediaWorkflowCompartment(ChangeMediaWorkflowCompartmentRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowId(), (String)"mediaWorkflowId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMediaWorkflowCompartmentDetails(), "changeMediaWorkflowCompartmentDetails is required");
        return (ChangeMediaWorkflowCompartmentResponse)this.clientCall(request, ChangeMediaWorkflowCompartmentResponse::builder).logger(LOG, "changeMediaWorkflowCompartment").serviceDetails("MediaServices", "ChangeMediaWorkflowCompartment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/ChangeMediaWorkflowCompartment").method(Method.POST).requestBuilder(ChangeMediaWorkflowCompartmentRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflows").appendPathParam(request.getMediaWorkflowId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMediaWorkflowCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMediaWorkflowCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeMediaWorkflowConfigurationCompartmentResponse changeMediaWorkflowConfigurationCompartment(ChangeMediaWorkflowConfigurationCompartmentRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowConfigurationId(), (String)"mediaWorkflowConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMediaWorkflowConfigurationCompartmentDetails(), "changeMediaWorkflowConfigurationCompartmentDetails is required");
        return (ChangeMediaWorkflowConfigurationCompartmentResponse)this.clientCall(request, ChangeMediaWorkflowConfigurationCompartmentResponse::builder).logger(LOG, "changeMediaWorkflowConfigurationCompartment").serviceDetails("MediaServices", "ChangeMediaWorkflowConfigurationCompartment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowConfiguration/ChangeMediaWorkflowConfigurationCompartment").method(Method.POST).requestBuilder(ChangeMediaWorkflowConfigurationCompartmentRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowConfigurations").appendPathParam(request.getMediaWorkflowConfigurationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMediaWorkflowConfigurationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMediaWorkflowConfigurationCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeMediaWorkflowJobCompartmentResponse changeMediaWorkflowJobCompartment(ChangeMediaWorkflowJobCompartmentRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowJobId(), (String)"mediaWorkflowJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMediaWorkflowJobCompartmentDetails(), "changeMediaWorkflowJobCompartmentDetails is required");
        return (ChangeMediaWorkflowJobCompartmentResponse)this.clientCall(request, ChangeMediaWorkflowJobCompartmentResponse::builder).logger(LOG, "changeMediaWorkflowJobCompartment").serviceDetails("MediaServices", "ChangeMediaWorkflowJobCompartment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJob/ChangeMediaWorkflowJobCompartment").method(Method.POST).requestBuilder(ChangeMediaWorkflowJobCompartmentRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendPathParam(request.getMediaWorkflowJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMediaWorkflowJobCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMediaWorkflowJobCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeStreamDistributionChannelCompartmentResponse changeStreamDistributionChannelCompartment(ChangeStreamDistributionChannelCompartmentRequest request) {
        Validate.notBlank((String)request.getStreamDistributionChannelId(), (String)"streamDistributionChannelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeStreamDistributionChannelCompartmentDetails(), "changeStreamDistributionChannelCompartmentDetails is required");
        return (ChangeStreamDistributionChannelCompartmentResponse)this.clientCall(request, ChangeStreamDistributionChannelCompartmentResponse::builder).logger(LOG, "changeStreamDistributionChannelCompartment").serviceDetails("MediaServices", "ChangeStreamDistributionChannelCompartment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/ChangeStreamDistributionChannelCompartment").method(Method.POST).requestBuilder(ChangeStreamDistributionChannelCompartmentRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").appendPathParam(request.getStreamDistributionChannelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeStreamDistributionChannelCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeStreamDistributionChannelCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMediaAssetResponse createMediaAsset(CreateMediaAssetRequest request) {
        Objects.requireNonNull(request.getCreateMediaAssetDetails(), "createMediaAssetDetails is required");
        return (CreateMediaAssetResponse)this.clientCall(request, CreateMediaAssetResponse::builder).logger(LOG, "createMediaAsset").serviceDetails("MediaServices", "CreateMediaAsset", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAsset/CreateMediaAsset").method(Method.POST).requestBuilder(CreateMediaAssetRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaAsset.class, CreateMediaAssetResponse.Builder::mediaAsset).handleResponseHeaderString("etag", CreateMediaAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMediaAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMediaWorkflowResponse createMediaWorkflow(CreateMediaWorkflowRequest request) {
        Objects.requireNonNull(request.getCreateMediaWorkflowDetails(), "createMediaWorkflowDetails is required");
        return (CreateMediaWorkflowResponse)this.clientCall(request, CreateMediaWorkflowResponse::builder).logger(LOG, "createMediaWorkflow").serviceDetails("MediaServices", "CreateMediaWorkflow", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/CreateMediaWorkflow").method(Method.POST).requestBuilder(CreateMediaWorkflowRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflows").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaWorkflow.class, CreateMediaWorkflowResponse.Builder::mediaWorkflow).handleResponseHeaderString("etag", CreateMediaWorkflowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMediaWorkflowResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMediaWorkflowConfigurationResponse createMediaWorkflowConfiguration(CreateMediaWorkflowConfigurationRequest request) {
        Objects.requireNonNull(request.getCreateMediaWorkflowConfigurationDetails(), "createMediaWorkflowConfigurationDetails is required");
        return (CreateMediaWorkflowConfigurationResponse)this.clientCall(request, CreateMediaWorkflowConfigurationResponse::builder).logger(LOG, "createMediaWorkflowConfiguration").serviceDetails("MediaServices", "CreateMediaWorkflowConfiguration", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowConfiguration/CreateMediaWorkflowConfiguration").method(Method.POST).requestBuilder(CreateMediaWorkflowConfigurationRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowConfigurations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaWorkflowConfiguration.class, CreateMediaWorkflowConfigurationResponse.Builder::mediaWorkflowConfiguration).handleResponseHeaderString("etag", CreateMediaWorkflowConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMediaWorkflowConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMediaWorkflowJobResponse createMediaWorkflowJob(CreateMediaWorkflowJobRequest request) {
        Objects.requireNonNull(request.getCreateMediaWorkflowJobDetails(), "createMediaWorkflowJobDetails is required");
        return (CreateMediaWorkflowJobResponse)this.clientCall(request, CreateMediaWorkflowJobResponse::builder).logger(LOG, "createMediaWorkflowJob").serviceDetails("MediaServices", "CreateMediaWorkflowJob", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJob/CreateMediaWorkflowJob").method(Method.POST).requestBuilder(CreateMediaWorkflowJobRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(MediaWorkflowJob.class, CreateMediaWorkflowJobResponse.Builder::mediaWorkflowJob).handleResponseHeaderString("etag", CreateMediaWorkflowJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMediaWorkflowJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateStreamCdnConfigResponse createStreamCdnConfig(CreateStreamCdnConfigRequest request) {
        Objects.requireNonNull(request.getCreateStreamCdnConfigDetails(), "createStreamCdnConfigDetails is required");
        return (CreateStreamCdnConfigResponse)this.clientCall(request, CreateStreamCdnConfigResponse::builder).logger(LOG, "createStreamCdnConfig").serviceDetails("MediaServices", "CreateStreamCdnConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamCdnConfig/CreateStreamCdnConfig").method(Method.POST).requestBuilder(CreateStreamCdnConfigRequest::builder).basePath("/20211101").appendPathParam("streamCdnConfigs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(StreamCdnConfig.class, CreateStreamCdnConfigResponse.Builder::streamCdnConfig).handleResponseHeaderString("etag", CreateStreamCdnConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateStreamCdnConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateStreamDistributionChannelResponse createStreamDistributionChannel(CreateStreamDistributionChannelRequest request) {
        Objects.requireNonNull(request.getCreateStreamDistributionChannelDetails(), "createStreamDistributionChannelDetails is required");
        return (CreateStreamDistributionChannelResponse)this.clientCall(request, CreateStreamDistributionChannelResponse::builder).logger(LOG, "createStreamDistributionChannel").serviceDetails("MediaServices", "CreateStreamDistributionChannel", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/CreateStreamDistributionChannel").method(Method.POST).requestBuilder(CreateStreamDistributionChannelRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(StreamDistributionChannel.class, CreateStreamDistributionChannelResponse.Builder::streamDistributionChannel).handleResponseHeaderString("etag", CreateStreamDistributionChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateStreamDistributionChannelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateStreamPackagingConfigResponse createStreamPackagingConfig(CreateStreamPackagingConfigRequest request) {
        Objects.requireNonNull(request.getCreateStreamPackagingConfigDetails(), "createStreamPackagingConfigDetails is required");
        return (CreateStreamPackagingConfigResponse)this.clientCall(request, CreateStreamPackagingConfigResponse::builder).logger(LOG, "createStreamPackagingConfig").serviceDetails("MediaServices", "CreateStreamPackagingConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamPackagingConfig/CreateStreamPackagingConfig").method(Method.POST).requestBuilder(CreateStreamPackagingConfigRequest::builder).basePath("/20211101").appendPathParam("streamPackagingConfigs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(StreamPackagingConfig.class, CreateStreamPackagingConfigResponse.Builder::streamPackagingConfig).handleResponseHeaderString("etag", CreateStreamPackagingConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateStreamPackagingConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMediaAssetResponse deleteMediaAsset(DeleteMediaAssetRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        return (DeleteMediaAssetResponse)this.clientCall(request, DeleteMediaAssetResponse::builder).logger(LOG, "deleteMediaAsset").serviceDetails("MediaServices", "DeleteMediaAsset", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAsset/DeleteMediaAsset").method(Method.DELETE).requestBuilder(DeleteMediaAssetRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).appendEnumQueryParam("deleteMode", (BmcEnum)request.getDeleteMode()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMediaAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMediaAssetDistributionChannelAttachmentResponse deleteMediaAssetDistributionChannelAttachment(DeleteMediaAssetDistributionChannelAttachmentRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDistributionChannelId(), (String)"distributionChannelId must not be blank", (Object[])new Object[0]);
        return (DeleteMediaAssetDistributionChannelAttachmentResponse)this.clientCall(request, DeleteMediaAssetDistributionChannelAttachmentResponse::builder).logger(LOG, "deleteMediaAssetDistributionChannelAttachment").serviceDetails("MediaServices", "DeleteMediaAssetDistributionChannelAttachment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAssetDistributionChannelAttachment/DeleteMediaAssetDistributionChannelAttachment").method(Method.DELETE).requestBuilder(DeleteMediaAssetDistributionChannelAttachmentRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).appendPathParam("distributionChannelAttachments").appendPathParam(request.getDistributionChannelId()).appendQueryParam("version", (Object)request.getVersion()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMediaAssetDistributionChannelAttachmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMediaWorkflowResponse deleteMediaWorkflow(DeleteMediaWorkflowRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowId(), (String)"mediaWorkflowId must not be blank", (Object[])new Object[0]);
        return (DeleteMediaWorkflowResponse)this.clientCall(request, DeleteMediaWorkflowResponse::builder).logger(LOG, "deleteMediaWorkflow").serviceDetails("MediaServices", "DeleteMediaWorkflow", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/DeleteMediaWorkflow").method(Method.DELETE).requestBuilder(DeleteMediaWorkflowRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflows").appendPathParam(request.getMediaWorkflowId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteMediaWorkflowResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMediaWorkflowConfigurationResponse deleteMediaWorkflowConfiguration(DeleteMediaWorkflowConfigurationRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowConfigurationId(), (String)"mediaWorkflowConfigurationId must not be blank", (Object[])new Object[0]);
        return (DeleteMediaWorkflowConfigurationResponse)this.clientCall(request, DeleteMediaWorkflowConfigurationResponse::builder).logger(LOG, "deleteMediaWorkflowConfiguration").serviceDetails("MediaServices", "DeleteMediaWorkflowConfiguration", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowConfiguration/DeleteMediaWorkflowConfiguration").method(Method.DELETE).requestBuilder(DeleteMediaWorkflowConfigurationRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowConfigurations").appendPathParam(request.getMediaWorkflowConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteMediaWorkflowConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMediaWorkflowConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMediaWorkflowJobResponse deleteMediaWorkflowJob(DeleteMediaWorkflowJobRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowJobId(), (String)"mediaWorkflowJobId must not be blank", (Object[])new Object[0]);
        return (DeleteMediaWorkflowJobResponse)this.clientCall(request, DeleteMediaWorkflowJobResponse::builder).logger(LOG, "deleteMediaWorkflowJob").serviceDetails("MediaServices", "DeleteMediaWorkflowJob", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJob/DeleteMediaWorkflowJob").method(Method.DELETE).requestBuilder(DeleteMediaWorkflowJobRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendPathParam(request.getMediaWorkflowJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteMediaWorkflowJobResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMediaWorkflowJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteStreamCdnConfigResponse deleteStreamCdnConfig(DeleteStreamCdnConfigRequest request) {
        Validate.notBlank((String)request.getStreamCdnConfigId(), (String)"streamCdnConfigId must not be blank", (Object[])new Object[0]);
        return (DeleteStreamCdnConfigResponse)this.clientCall(request, DeleteStreamCdnConfigResponse::builder).logger(LOG, "deleteStreamCdnConfig").serviceDetails("MediaServices", "DeleteStreamCdnConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamCdnConfig/DeleteStreamCdnConfig").method(Method.DELETE).requestBuilder(DeleteStreamCdnConfigRequest::builder).basePath("/20211101").appendPathParam("streamCdnConfigs").appendPathParam(request.getStreamCdnConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamCdnConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteStreamDistributionChannelResponse deleteStreamDistributionChannel(DeleteStreamDistributionChannelRequest request) {
        Validate.notBlank((String)request.getStreamDistributionChannelId(), (String)"streamDistributionChannelId must not be blank", (Object[])new Object[0]);
        return (DeleteStreamDistributionChannelResponse)this.clientCall(request, DeleteStreamDistributionChannelResponse::builder).logger(LOG, "deleteStreamDistributionChannel").serviceDetails("MediaServices", "DeleteStreamDistributionChannel", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/DeleteStreamDistributionChannel").method(Method.DELETE).requestBuilder(DeleteStreamDistributionChannelRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").appendPathParam(request.getStreamDistributionChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamDistributionChannelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteStreamPackagingConfigResponse deleteStreamPackagingConfig(DeleteStreamPackagingConfigRequest request) {
        Validate.notBlank((String)request.getStreamPackagingConfigId(), (String)"streamPackagingConfigId must not be blank", (Object[])new Object[0]);
        return (DeleteStreamPackagingConfigResponse)this.clientCall(request, DeleteStreamPackagingConfigResponse::builder).logger(LOG, "deleteStreamPackagingConfig").serviceDetails("MediaServices", "DeleteStreamPackagingConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamPackagingConfig/DeleteStreamPackagingConfig").method(Method.DELETE).requestBuilder(DeleteStreamPackagingConfigRequest::builder).basePath("/20211101").appendPathParam("streamPackagingConfigs").appendPathParam(request.getStreamPackagingConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamPackagingConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMediaAssetResponse getMediaAsset(GetMediaAssetRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        return (GetMediaAssetResponse)this.clientCall(request, GetMediaAssetResponse::builder).logger(LOG, "getMediaAsset").serviceDetails("MediaServices", "GetMediaAsset", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAsset/GetMediaAsset").method(Method.GET).requestBuilder(GetMediaAssetRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaAsset.class, GetMediaAssetResponse.Builder::mediaAsset).handleResponseHeaderString("etag", GetMediaAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMediaAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMediaAssetDistributionChannelAttachmentResponse getMediaAssetDistributionChannelAttachment(GetMediaAssetDistributionChannelAttachmentRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDistributionChannelId(), (String)"distributionChannelId must not be blank", (Object[])new Object[0]);
        return (GetMediaAssetDistributionChannelAttachmentResponse)this.clientCall(request, GetMediaAssetDistributionChannelAttachmentResponse::builder).logger(LOG, "getMediaAssetDistributionChannelAttachment").serviceDetails("MediaServices", "GetMediaAssetDistributionChannelAttachment", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAssetDistributionChannelAttachment/GetMediaAssetDistributionChannelAttachment").method(Method.GET).requestBuilder(GetMediaAssetDistributionChannelAttachmentRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).appendPathParam("distributionChannelAttachments").appendPathParam(request.getDistributionChannelId()).appendQueryParam("version", (Object)request.getVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaAssetDistributionChannelAttachment.class, GetMediaAssetDistributionChannelAttachmentResponse.Builder::mediaAssetDistributionChannelAttachment).handleResponseHeaderString("etag", GetMediaAssetDistributionChannelAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMediaAssetDistributionChannelAttachmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMediaWorkflowResponse getMediaWorkflow(GetMediaWorkflowRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowId(), (String)"mediaWorkflowId must not be blank", (Object[])new Object[0]);
        return (GetMediaWorkflowResponse)this.clientCall(request, GetMediaWorkflowResponse::builder).logger(LOG, "getMediaWorkflow").serviceDetails("MediaServices", "GetMediaWorkflow", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/GetMediaWorkflow").method(Method.GET).requestBuilder(GetMediaWorkflowRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflows").appendPathParam(request.getMediaWorkflowId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflow.class, GetMediaWorkflowResponse.Builder::mediaWorkflow).handleResponseHeaderString("etag", GetMediaWorkflowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMediaWorkflowResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMediaWorkflowConfigurationResponse getMediaWorkflowConfiguration(GetMediaWorkflowConfigurationRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowConfigurationId(), (String)"mediaWorkflowConfigurationId must not be blank", (Object[])new Object[0]);
        return (GetMediaWorkflowConfigurationResponse)this.clientCall(request, GetMediaWorkflowConfigurationResponse::builder).logger(LOG, "getMediaWorkflowConfiguration").serviceDetails("MediaServices", "GetMediaWorkflowConfiguration", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowConfiguration/GetMediaWorkflowConfiguration").method(Method.GET).requestBuilder(GetMediaWorkflowConfigurationRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowConfigurations").appendPathParam(request.getMediaWorkflowConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowConfiguration.class, GetMediaWorkflowConfigurationResponse.Builder::mediaWorkflowConfiguration).handleResponseHeaderString("etag", GetMediaWorkflowConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMediaWorkflowConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMediaWorkflowJobResponse getMediaWorkflowJob(GetMediaWorkflowJobRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowJobId(), (String)"mediaWorkflowJobId must not be blank", (Object[])new Object[0]);
        return (GetMediaWorkflowJobResponse)this.clientCall(request, GetMediaWorkflowJobResponse::builder).logger(LOG, "getMediaWorkflowJob").serviceDetails("MediaServices", "GetMediaWorkflowJob", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJob/GetMediaWorkflowJob").method(Method.GET).requestBuilder(GetMediaWorkflowJobRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendPathParam(request.getMediaWorkflowJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowJob.class, GetMediaWorkflowJobResponse.Builder::mediaWorkflowJob).handleResponseHeaderString("etag", GetMediaWorkflowJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMediaWorkflowJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMediaWorkflowJobFactResponse getMediaWorkflowJobFact(GetMediaWorkflowJobFactRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowJobId(), (String)"mediaWorkflowJobId must not be blank", (Object[])new Object[0]);
        return (GetMediaWorkflowJobFactResponse)this.clientCall(request, GetMediaWorkflowJobFactResponse::builder).logger(LOG, "getMediaWorkflowJobFact").serviceDetails("MediaServices", "GetMediaWorkflowJobFact", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJobFact/GetMediaWorkflowJobFact").method(Method.GET).requestBuilder(GetMediaWorkflowJobFactRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendPathParam(request.getMediaWorkflowJobId()).appendPathParam("facts").appendPathParam((Number)request.getKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowJobFact.class, GetMediaWorkflowJobFactResponse.Builder::mediaWorkflowJobFact).handleResponseHeaderString("etag", GetMediaWorkflowJobFactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMediaWorkflowJobFactResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStreamCdnConfigResponse getStreamCdnConfig(GetStreamCdnConfigRequest request) {
        Validate.notBlank((String)request.getStreamCdnConfigId(), (String)"streamCdnConfigId must not be blank", (Object[])new Object[0]);
        return (GetStreamCdnConfigResponse)this.clientCall(request, GetStreamCdnConfigResponse::builder).logger(LOG, "getStreamCdnConfig").serviceDetails("MediaServices", "GetStreamCdnConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamCdnConfig/GetStreamCdnConfig").method(Method.GET).requestBuilder(GetStreamCdnConfigRequest::builder).basePath("/20211101").appendPathParam("streamCdnConfigs").appendPathParam(request.getStreamCdnConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamCdnConfig.class, GetStreamCdnConfigResponse.Builder::streamCdnConfig).handleResponseHeaderString("etag", GetStreamCdnConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetStreamCdnConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStreamDistributionChannelResponse getStreamDistributionChannel(GetStreamDistributionChannelRequest request) {
        Validate.notBlank((String)request.getStreamDistributionChannelId(), (String)"streamDistributionChannelId must not be blank", (Object[])new Object[0]);
        return (GetStreamDistributionChannelResponse)this.clientCall(request, GetStreamDistributionChannelResponse::builder).logger(LOG, "getStreamDistributionChannel").serviceDetails("MediaServices", "GetStreamDistributionChannel", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/GetStreamDistributionChannel").method(Method.GET).requestBuilder(GetStreamDistributionChannelRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").appendPathParam(request.getStreamDistributionChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamDistributionChannel.class, GetStreamDistributionChannelResponse.Builder::streamDistributionChannel).handleResponseHeaderString("etag", GetStreamDistributionChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetStreamDistributionChannelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStreamPackagingConfigResponse getStreamPackagingConfig(GetStreamPackagingConfigRequest request) {
        Validate.notBlank((String)request.getStreamPackagingConfigId(), (String)"streamPackagingConfigId must not be blank", (Object[])new Object[0]);
        return (GetStreamPackagingConfigResponse)this.clientCall(request, GetStreamPackagingConfigResponse::builder).logger(LOG, "getStreamPackagingConfig").serviceDetails("MediaServices", "GetStreamPackagingConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamPackagingConfig/GetStreamPackagingConfig").method(Method.GET).requestBuilder(GetStreamPackagingConfigRequest::builder).basePath("/20211101").appendPathParam("streamPackagingConfigs").appendPathParam(request.getStreamPackagingConfigId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamPackagingConfig.class, GetStreamPackagingConfigResponse.Builder::streamPackagingConfig).handleResponseHeaderString("etag", GetStreamPackagingConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetStreamPackagingConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public IngestStreamDistributionChannelResponse ingestStreamDistributionChannel(IngestStreamDistributionChannelRequest request) {
        Validate.notBlank((String)request.getStreamDistributionChannelId(), (String)"streamDistributionChannelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getIngestStreamDistributionChannelDetails(), "ingestStreamDistributionChannelDetails is required");
        return (IngestStreamDistributionChannelResponse)this.clientCall(request, IngestStreamDistributionChannelResponse::builder).logger(LOG, "ingestStreamDistributionChannel").serviceDetails("MediaServices", "IngestStreamDistributionChannel", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/IngestStreamDistributionChannel").method(Method.POST).requestBuilder(IngestStreamDistributionChannelRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").appendPathParam(request.getStreamDistributionChannelId()).appendPathParam("actions").appendPathParam("ingest").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IngestStreamDistributionChannelResult.class, IngestStreamDistributionChannelResponse.Builder::ingestStreamDistributionChannelResult).handleResponseHeaderString("opc-request-id", IngestStreamDistributionChannelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaAssetDistributionChannelAttachmentsResponse listMediaAssetDistributionChannelAttachments(ListMediaAssetDistributionChannelAttachmentsRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        return (ListMediaAssetDistributionChannelAttachmentsResponse)this.clientCall(request, ListMediaAssetDistributionChannelAttachmentsResponse::builder).logger(LOG, "listMediaAssetDistributionChannelAttachments").serviceDetails("MediaServices", "ListMediaAssetDistributionChannelAttachments", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAssetDistributionChannelAttachmentCollection/ListMediaAssetDistributionChannelAttachments").method(Method.GET).requestBuilder(ListMediaAssetDistributionChannelAttachmentsRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).appendPathParam("distributionChannelAttachments").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("distributionChannelId", (Object)request.getDistributionChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaAssetDistributionChannelAttachmentCollection.class, ListMediaAssetDistributionChannelAttachmentsResponse.Builder::mediaAssetDistributionChannelAttachmentCollection).handleResponseHeaderString("opc-request-id", ListMediaAssetDistributionChannelAttachmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaAssetDistributionChannelAttachmentsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaAssetsResponse listMediaAssets(ListMediaAssetsRequest request) {
        return (ListMediaAssetsResponse)this.clientCall(request, ListMediaAssetsResponse::builder).logger(LOG, "listMediaAssets").serviceDetails("MediaServices", "ListMediaAssets", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAsset/ListMediaAssets").method(Method.GET).requestBuilder(ListMediaAssetsRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("distributionChannelId", (Object)request.getDistributionChannelId()).appendQueryParam("parentMediaAssetId", (Object)request.getParentMediaAssetId()).appendQueryParam("masterMediaAssetId", (Object)request.getMasterMediaAssetId()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("bucketName", (Object)request.getBucketName()).appendQueryParam("objectName", (Object)request.getObjectName()).appendQueryParam("mediaWorkflowJobId", (Object)request.getMediaWorkflowJobId()).appendQueryParam("sourceMediaWorkflowId", (Object)request.getSourceMediaWorkflowId()).appendQueryParam("sourceMediaWorkflowVersion", (Object)request.getSourceMediaWorkflowVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaAssetCollection.class, ListMediaAssetsResponse.Builder::mediaAssetCollection).handleResponseHeaderString("opc-request-id", ListMediaAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaAssetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaWorkflowConfigurationsResponse listMediaWorkflowConfigurations(ListMediaWorkflowConfigurationsRequest request) {
        return (ListMediaWorkflowConfigurationsResponse)this.clientCall(request, ListMediaWorkflowConfigurationsResponse::builder).logger(LOG, "listMediaWorkflowConfigurations").serviceDetails("MediaServices", "ListMediaWorkflowConfigurations", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowConfigurationCollection/ListMediaWorkflowConfigurations").method(Method.GET).requestBuilder(ListMediaWorkflowConfigurationsRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowConfigurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowConfigurationCollection.class, ListMediaWorkflowConfigurationsResponse.Builder::mediaWorkflowConfigurationCollection).handleResponseHeaderString("opc-request-id", ListMediaWorkflowConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaWorkflowConfigurationsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaWorkflowJobFactsResponse listMediaWorkflowJobFacts(ListMediaWorkflowJobFactsRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowJobId(), (String)"mediaWorkflowJobId must not be blank", (Object[])new Object[0]);
        return (ListMediaWorkflowJobFactsResponse)this.clientCall(request, ListMediaWorkflowJobFactsResponse::builder).logger(LOG, "listMediaWorkflowJobFacts").serviceDetails("MediaServices", "ListMediaWorkflowJobFacts", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJobFact/ListMediaWorkflowJobFacts").method(Method.GET).requestBuilder(ListMediaWorkflowJobFactsRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendPathParam(request.getMediaWorkflowJobId()).appendPathParam("facts").appendQueryParam("key", (Object)request.getKey()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowJobFactCollection.class, ListMediaWorkflowJobFactsResponse.Builder::mediaWorkflowJobFactCollection).handleResponseHeaderString("opc-request-id", ListMediaWorkflowJobFactsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaWorkflowJobFactsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaWorkflowJobsResponse listMediaWorkflowJobs(ListMediaWorkflowJobsRequest request) {
        return (ListMediaWorkflowJobsResponse)this.clientCall(request, ListMediaWorkflowJobsResponse::builder).logger(LOG, "listMediaWorkflowJobs").serviceDetails("MediaServices", "ListMediaWorkflowJobs", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJob/ListMediaWorkflowJobs").method(Method.GET).requestBuilder(ListMediaWorkflowJobsRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("mediaWorkflowId", (Object)request.getMediaWorkflowId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowJobCollection.class, ListMediaWorkflowJobsResponse.Builder::mediaWorkflowJobCollection).handleResponseHeaderString("opc-request-id", ListMediaWorkflowJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaWorkflowJobsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaWorkflowTaskDeclarationsResponse listMediaWorkflowTaskDeclarations(ListMediaWorkflowTaskDeclarationsRequest request) {
        return (ListMediaWorkflowTaskDeclarationsResponse)this.clientCall(request, ListMediaWorkflowTaskDeclarationsResponse::builder).logger(LOG, "listMediaWorkflowTaskDeclarations").serviceDetails("MediaServices", "ListMediaWorkflowTaskDeclarations", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowTaskDeclarationCollection/ListMediaWorkflowTaskDeclarations").method(Method.GET).requestBuilder(ListMediaWorkflowTaskDeclarationsRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowTaskDeclarations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("isCurrent", (Object)request.getIsCurrent()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowTaskDeclarationCollection.class, ListMediaWorkflowTaskDeclarationsResponse.Builder::mediaWorkflowTaskDeclarationCollection).handleResponseHeaderString("opc-request-id", ListMediaWorkflowTaskDeclarationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaWorkflowTaskDeclarationsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMediaWorkflowsResponse listMediaWorkflows(ListMediaWorkflowsRequest request) {
        return (ListMediaWorkflowsResponse)this.clientCall(request, ListMediaWorkflowsResponse::builder).logger(LOG, "listMediaWorkflows").serviceDetails("MediaServices", "ListMediaWorkflows", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/ListMediaWorkflows").method(Method.GET).requestBuilder(ListMediaWorkflowsRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflows").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MediaWorkflowCollection.class, ListMediaWorkflowsResponse.Builder::mediaWorkflowCollection).handleResponseHeaderString("opc-request-id", ListMediaWorkflowsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMediaWorkflowsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStreamCdnConfigsResponse listStreamCdnConfigs(ListStreamCdnConfigsRequest request) {
        Objects.requireNonNull(request.getDistributionChannelId(), "distributionChannelId is required");
        return (ListStreamCdnConfigsResponse)this.clientCall(request, ListStreamCdnConfigsResponse::builder).logger(LOG, "listStreamCdnConfigs").serviceDetails("MediaServices", "ListStreamCdnConfigs", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamCdnConfig/ListStreamCdnConfigs").method(Method.GET).requestBuilder(ListStreamCdnConfigsRequest::builder).basePath("/20211101").appendPathParam("streamCdnConfigs").appendQueryParam("distributionChannelId", (Object)request.getDistributionChannelId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamCdnConfigCollection.class, ListStreamCdnConfigsResponse.Builder::streamCdnConfigCollection).handleResponseHeaderString("opc-request-id", ListStreamCdnConfigsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStreamCdnConfigsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStreamDistributionChannelsResponse listStreamDistributionChannels(ListStreamDistributionChannelsRequest request) {
        return (ListStreamDistributionChannelsResponse)this.clientCall(request, ListStreamDistributionChannelsResponse::builder).logger(LOG, "listStreamDistributionChannels").serviceDetails("MediaServices", "ListStreamDistributionChannels", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/ListStreamDistributionChannels").method(Method.GET).requestBuilder(ListStreamDistributionChannelsRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamDistributionChannelCollection.class, ListStreamDistributionChannelsResponse.Builder::streamDistributionChannelCollection).handleResponseHeaderString("opc-request-id", ListStreamDistributionChannelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStreamDistributionChannelsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStreamPackagingConfigsResponse listStreamPackagingConfigs(ListStreamPackagingConfigsRequest request) {
        Objects.requireNonNull(request.getDistributionChannelId(), "distributionChannelId is required");
        return (ListStreamPackagingConfigsResponse)this.clientCall(request, ListStreamPackagingConfigsResponse::builder).logger(LOG, "listStreamPackagingConfigs").serviceDetails("MediaServices", "ListStreamPackagingConfigs", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamPackagingConfig/ListStreamPackagingConfigs").method(Method.GET).requestBuilder(ListStreamPackagingConfigsRequest::builder).basePath("/20211101").appendPathParam("streamPackagingConfigs").appendQueryParam("distributionChannelId", (Object)request.getDistributionChannelId()).appendQueryParam("streamPackagingConfigId", (Object)request.getStreamPackagingConfigId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamPackagingConfigCollection.class, ListStreamPackagingConfigsResponse.Builder::streamPackagingConfigCollection).handleResponseHeaderString("opc-request-id", ListStreamPackagingConfigsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStreamPackagingConfigsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSystemMediaWorkflowsResponse listSystemMediaWorkflows(ListSystemMediaWorkflowsRequest request) {
        return (ListSystemMediaWorkflowsResponse)this.clientCall(request, ListSystemMediaWorkflowsResponse::builder).logger(LOG, "listSystemMediaWorkflows").serviceDetails("MediaServices", "ListSystemMediaWorkflows", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/ListSystemMediaWorkflows").method(Method.GET).requestBuilder(ListSystemMediaWorkflowsRequest::builder).basePath("/20211101").appendPathParam("systemMediaWorkflows").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SystemMediaWorkflowCollection.class, ListSystemMediaWorkflowsResponse.Builder::systemMediaWorkflowCollection).handleResponseHeaderString("opc-request-id", ListSystemMediaWorkflowsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSystemMediaWorkflowsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMediaAssetResponse updateMediaAsset(UpdateMediaAssetRequest request) {
        Validate.notBlank((String)request.getMediaAssetId(), (String)"mediaAssetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMediaAssetDetails(), "updateMediaAssetDetails is required");
        return (UpdateMediaAssetResponse)this.clientCall(request, UpdateMediaAssetResponse::builder).logger(LOG, "updateMediaAsset").serviceDetails("MediaServices", "UpdateMediaAsset", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaAsset/UpdateMediaAsset").method(Method.PUT).requestBuilder(UpdateMediaAssetRequest::builder).basePath("/20211101").appendPathParam("mediaAssets").appendPathParam(request.getMediaAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaAsset.class, UpdateMediaAssetResponse.Builder::mediaAsset).handleResponseHeaderString("etag", UpdateMediaAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMediaAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMediaWorkflowResponse updateMediaWorkflow(UpdateMediaWorkflowRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowId(), (String)"mediaWorkflowId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMediaWorkflowDetails(), "updateMediaWorkflowDetails is required");
        return (UpdateMediaWorkflowResponse)this.clientCall(request, UpdateMediaWorkflowResponse::builder).logger(LOG, "updateMediaWorkflow").serviceDetails("MediaServices", "UpdateMediaWorkflow", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflow/UpdateMediaWorkflow").method(Method.PUT).requestBuilder(UpdateMediaWorkflowRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflows").appendPathParam(request.getMediaWorkflowId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaWorkflow.class, UpdateMediaWorkflowResponse.Builder::mediaWorkflow).handleResponseHeaderString("etag", UpdateMediaWorkflowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMediaWorkflowResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMediaWorkflowConfigurationResponse updateMediaWorkflowConfiguration(UpdateMediaWorkflowConfigurationRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowConfigurationId(), (String)"mediaWorkflowConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMediaWorkflowConfigurationDetails(), "updateMediaWorkflowConfigurationDetails is required");
        return (UpdateMediaWorkflowConfigurationResponse)this.clientCall(request, UpdateMediaWorkflowConfigurationResponse::builder).logger(LOG, "updateMediaWorkflowConfiguration").serviceDetails("MediaServices", "UpdateMediaWorkflowConfiguration", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowConfiguration/UpdateMediaWorkflowConfiguration").method(Method.PUT).requestBuilder(UpdateMediaWorkflowConfigurationRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowConfigurations").appendPathParam(request.getMediaWorkflowConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaWorkflowConfiguration.class, UpdateMediaWorkflowConfigurationResponse.Builder::mediaWorkflowConfiguration).handleResponseHeaderString("etag", UpdateMediaWorkflowConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMediaWorkflowConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMediaWorkflowJobResponse updateMediaWorkflowJob(UpdateMediaWorkflowJobRequest request) {
        Validate.notBlank((String)request.getMediaWorkflowJobId(), (String)"mediaWorkflowJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMediaWorkflowJobDetails(), "updateMediaWorkflowJobDetails is required");
        return (UpdateMediaWorkflowJobResponse)this.clientCall(request, UpdateMediaWorkflowJobResponse::builder).logger(LOG, "updateMediaWorkflowJob").serviceDetails("MediaServices", "UpdateMediaWorkflowJob", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/MediaWorkflowJob/UpdateMediaWorkflowJob").method(Method.PUT).requestBuilder(UpdateMediaWorkflowJobRequest::builder).basePath("/20211101").appendPathParam("mediaWorkflowJobs").appendPathParam(request.getMediaWorkflowJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MediaWorkflowJob.class, UpdateMediaWorkflowJobResponse.Builder::mediaWorkflowJob).handleResponseHeaderString("etag", UpdateMediaWorkflowJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMediaWorkflowJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStreamCdnConfigResponse updateStreamCdnConfig(UpdateStreamCdnConfigRequest request) {
        Validate.notBlank((String)request.getStreamCdnConfigId(), (String)"streamCdnConfigId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamCdnConfigDetails(), "updateStreamCdnConfigDetails is required");
        return (UpdateStreamCdnConfigResponse)this.clientCall(request, UpdateStreamCdnConfigResponse::builder).logger(LOG, "updateStreamCdnConfig").serviceDetails("MediaServices", "UpdateStreamCdnConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamCdnConfig/UpdateStreamCdnConfig").method(Method.PUT).requestBuilder(UpdateStreamCdnConfigRequest::builder).basePath("/20211101").appendPathParam("streamCdnConfigs").appendPathParam(request.getStreamCdnConfigId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(StreamCdnConfig.class, UpdateStreamCdnConfigResponse.Builder::streamCdnConfig).handleResponseHeaderString("etag", UpdateStreamCdnConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateStreamCdnConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStreamDistributionChannelResponse updateStreamDistributionChannel(UpdateStreamDistributionChannelRequest request) {
        Validate.notBlank((String)request.getStreamDistributionChannelId(), (String)"streamDistributionChannelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamDistributionChannelDetails(), "updateStreamDistributionChannelDetails is required");
        return (UpdateStreamDistributionChannelResponse)this.clientCall(request, UpdateStreamDistributionChannelResponse::builder).logger(LOG, "updateStreamDistributionChannel").serviceDetails("MediaServices", "UpdateStreamDistributionChannel", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamDistributionChannel/UpdateStreamDistributionChannel").method(Method.PUT).requestBuilder(UpdateStreamDistributionChannelRequest::builder).basePath("/20211101").appendPathParam("streamDistributionChannels").appendPathParam(request.getStreamDistributionChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(StreamDistributionChannel.class, UpdateStreamDistributionChannelResponse.Builder::streamDistributionChannel).handleResponseHeaderString("etag", UpdateStreamDistributionChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateStreamDistributionChannelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStreamPackagingConfigResponse updateStreamPackagingConfig(UpdateStreamPackagingConfigRequest request) {
        Validate.notBlank((String)request.getStreamPackagingConfigId(), (String)"streamPackagingConfigId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamPackagingConfigDetails(), "updateStreamPackagingConfigDetails is required");
        return (UpdateStreamPackagingConfigResponse)this.clientCall(request, UpdateStreamPackagingConfigResponse::builder).logger(LOG, "updateStreamPackagingConfig").serviceDetails("MediaServices", "UpdateStreamPackagingConfig", "https://docs.oracle.com/iaas/api/#/en/dms/20211101/StreamPackagingConfig/UpdateStreamPackagingConfig").method(Method.PUT).requestBuilder(UpdateStreamPackagingConfigRequest::builder).basePath("/20211101").appendPathParam("streamPackagingConfigs").appendPathParam(request.getStreamPackagingConfigId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(StreamPackagingConfig.class, UpdateStreamPackagingConfigResponse.Builder::streamPackagingConfig).handleResponseHeaderString("etag", UpdateStreamPackagingConfigResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateStreamPackagingConfigResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateStreamPackagingConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public MediaServicesWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public MediaServicesPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public MediaServicesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)MediaServicesClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(MediaServicesClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)MediaServicesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)MediaServicesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)MediaServicesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)MediaServicesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MediaServicesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MediaServicesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MediaServicesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MediaServicesClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public MediaServicesClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new MediaServicesClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

