/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.responses;

import com.oracle.bmc.marketplace.model.Publication;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetPublicationResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private Publication publication;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Publication getPublication() {
        return this.publication;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "publication"})
    private GetPublicationResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, Publication publication) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.publication = publication;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",publication=").append(String.valueOf((Object)this.publication));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPublicationResponse)) {
            return false;
        }
        GetPublicationResponse other = (GetPublicationResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.publication, (Object)other.publication);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.publication == null ? 43 : this.publication.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetPublicationResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private Publication publication;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder publication(Publication publication) {
            this.publication = publication;
            return this;
        }

        public Builder copy(GetPublicationResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.publication(o.getPublication());
            return this;
        }

        public GetPublicationResponse build() {
            return new GetPublicationResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.publication);
        }
    }
}

