/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.responses;

import com.oracle.bmc.marketplace.model.ListingPackage;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetPackageResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private ListingPackage listingPackage;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ListingPackage getListingPackage() {
        return this.listingPackage;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "listingPackage"})
    private GetPackageResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, ListingPackage listingPackage) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.listingPackage = listingPackage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",listingPackage=").append(String.valueOf((Object)this.listingPackage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPackageResponse)) {
            return false;
        }
        GetPackageResponse other = (GetPackageResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.listingPackage, (Object)other.listingPackage);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.listingPackage == null ? 43 : this.listingPackage.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetPackageResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private ListingPackage listingPackage;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder listingPackage(ListingPackage listingPackage) {
            this.listingPackage = listingPackage;
            return this;
        }

        public Builder copy(GetPackageResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.listingPackage(o.getListingPackage());
            return this;
        }

        public GetPackageResponse build() {
            return new GetPackageResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.listingPackage);
        }
    }
}

