/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.marketplace.model.UpdatePublicationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePublicationRequest
extends BmcRequest<UpdatePublicationDetails> {
    private String publicationId;
    private UpdatePublicationDetails updatePublicationDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getPublicationId() {
        return this.publicationId;
    }

    public UpdatePublicationDetails getUpdatePublicationDetails() {
        return this.updatePublicationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePublicationDetails getBody$() {
        return this.updatePublicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().publicationId(this.publicationId).updatePublicationDetails(this.updatePublicationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",publicationId=").append(String.valueOf(this.publicationId));
        sb.append(",updatePublicationDetails=").append(String.valueOf((Object)this.updatePublicationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePublicationRequest)) {
            return false;
        }
        UpdatePublicationRequest other = (UpdatePublicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.publicationId, other.publicationId) && Objects.equals((Object)this.updatePublicationDetails, (Object)other.updatePublicationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.publicationId == null ? 43 : this.publicationId.hashCode());
        result = result * 59 + (this.updatePublicationDetails == null ? 43 : this.updatePublicationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePublicationRequest, UpdatePublicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String publicationId = null;
        private UpdatePublicationDetails updatePublicationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder publicationId(String publicationId) {
            this.publicationId = publicationId;
            return this;
        }

        public Builder updatePublicationDetails(UpdatePublicationDetails updatePublicationDetails) {
            this.updatePublicationDetails = updatePublicationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePublicationRequest o) {
            this.publicationId(o.getPublicationId());
            this.updatePublicationDetails(o.getUpdatePublicationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePublicationRequest build() {
            UpdatePublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePublicationDetails body) {
            this.updatePublicationDetails(body);
            return this;
        }

        public UpdatePublicationRequest buildWithoutInvocationCallback() {
            UpdatePublicationRequest request = new UpdatePublicationRequest();
            request.publicationId = this.publicationId;
            request.updatePublicationDetails = this.updatePublicationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

