/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListReportsRequest
extends BmcRequest<Void> {
    private String reportType;
    private Date date;
    private String compartmentId;
    private String opcRequestId;
    private String page;

    public String getReportType() {
        return this.reportType;
    }

    public Date getDate() {
        return this.date;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().reportType(this.reportType).date(this.date).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",reportType=").append(String.valueOf(this.reportType));
        sb.append(",date=").append(String.valueOf(this.date));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListReportsRequest)) {
            return false;
        }
        ListReportsRequest other = (ListReportsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.reportType, other.reportType) && Objects.equals(this.date, other.date) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reportType == null ? 43 : this.reportType.hashCode());
        result = result * 59 + (this.date == null ? 43 : this.date.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListReportsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String reportType = null;
        private Date date = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private String page = null;

        public Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        public Builder date(Date date) {
            this.date = date;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListReportsRequest o) {
            this.reportType(o.getReportType());
            this.date(o.getDate());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListReportsRequest build() {
            ListReportsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListReportsRequest buildWithoutInvocationCallback() {
            ListReportsRequest request = new ListReportsRequest();
            request.reportType = this.reportType;
            request.date = this.date;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            return request;
        }
    }
}

