/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.marketplace.model.ListingType;
import com.oracle.bmc.marketplace.model.PricingTypeEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListListingsRequest
extends BmcRequest<Void> {
    private List<String> name;
    private String listingId;
    private String imageId;
    private String publisherId;
    private String packageType;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private List<String> category;
    private List<PricingTypeEnum> pricing;
    private Boolean isFeatured;
    private List<ListingType> listingTypes;
    private List<String> operatingSystems;
    private String compartmentId;

    public List<String> getName() {
        return this.name;
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public List<PricingTypeEnum> getPricing() {
        return this.pricing;
    }

    public Boolean getIsFeatured() {
        return this.isFeatured;
    }

    public List<ListingType> getListingTypes() {
        return this.listingTypes;
    }

    public List<String> getOperatingSystems() {
        return this.operatingSystems;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).listingId(this.listingId).imageId(this.imageId).publisherId(this.publisherId).packageType(this.packageType).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).category(this.category).pricing(this.pricing).isFeatured(this.isFeatured).listingTypes(this.listingTypes).operatingSystems(this.operatingSystems).compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",listingId=").append(String.valueOf(this.listingId));
        sb.append(",imageId=").append(String.valueOf(this.imageId));
        sb.append(",publisherId=").append(String.valueOf(this.publisherId));
        sb.append(",packageType=").append(String.valueOf(this.packageType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",category=").append(String.valueOf(this.category));
        sb.append(",pricing=").append(String.valueOf(this.pricing));
        sb.append(",isFeatured=").append(String.valueOf(this.isFeatured));
        sb.append(",listingTypes=").append(String.valueOf(this.listingTypes));
        sb.append(",operatingSystems=").append(String.valueOf(this.operatingSystems));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListListingsRequest)) {
            return false;
        }
        ListListingsRequest other = (ListListingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.name, other.name) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.imageId, other.imageId) && Objects.equals(this.publisherId, other.publisherId) && Objects.equals(this.packageType, other.packageType) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.category, other.category) && Objects.equals(this.pricing, other.pricing) && Objects.equals(this.isFeatured, other.isFeatured) && Objects.equals(this.listingTypes, other.listingTypes) && Objects.equals(this.operatingSystems, other.operatingSystems) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.publisherId == null ? 43 : this.publisherId.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.pricing == null ? 43 : this.pricing.hashCode());
        result = result * 59 + (this.isFeatured == null ? 43 : this.isFeatured.hashCode());
        result = result * 59 + (this.listingTypes == null ? 43 : this.listingTypes.hashCode());
        result = result * 59 + (this.operatingSystems == null ? 43 : this.operatingSystems.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListListingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private List<String> name = null;
        private String listingId = null;
        private String imageId = null;
        private String publisherId = null;
        private String packageType = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private List<String> category = null;
        private List<PricingTypeEnum> pricing = null;
        private Boolean isFeatured = null;
        private List<ListingType> listingTypes = null;
        private List<String> operatingSystems = null;
        private String compartmentId = null;

        public Builder name(List<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String singularValue) {
            return this.name(Arrays.asList(singularValue));
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder category(List<String> category) {
            this.category = category;
            return this;
        }

        public Builder category(String singularValue) {
            return this.category(Arrays.asList(singularValue));
        }

        public Builder pricing(List<PricingTypeEnum> pricing) {
            this.pricing = pricing;
            return this;
        }

        public Builder pricing(PricingTypeEnum singularValue) {
            return this.pricing(Arrays.asList(singularValue));
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            return this;
        }

        public Builder listingTypes(List<ListingType> listingTypes) {
            this.listingTypes = listingTypes;
            return this;
        }

        public Builder listingTypes(ListingType singularValue) {
            return this.listingTypes(Arrays.asList(singularValue));
        }

        public Builder operatingSystems(List<String> operatingSystems) {
            this.operatingSystems = operatingSystems;
            return this;
        }

        public Builder operatingSystems(String singularValue) {
            return this.operatingSystems(Arrays.asList(singularValue));
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListListingsRequest o) {
            this.name(o.getName());
            this.listingId(o.getListingId());
            this.imageId(o.getImageId());
            this.publisherId(o.getPublisherId());
            this.packageType(o.getPackageType());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.category(o.getCategory());
            this.pricing(o.getPricing());
            this.isFeatured(o.getIsFeatured());
            this.listingTypes(o.getListingTypes());
            this.operatingSystems(o.getOperatingSystems());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListListingsRequest build() {
            ListListingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListListingsRequest buildWithoutInvocationCallback() {
            ListListingsRequest request = new ListListingsRequest();
            request.name = this.name;
            request.listingId = this.listingId;
            request.imageId = this.imageId;
            request.publisherId = this.publisherId;
            request.packageType = this.packageType;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.category = this.category;
            request.pricing = this.pricing;
            request.isFeatured = this.isFeatured;
            request.listingTypes = this.listingTypes;
            request.operatingSystems = this.operatingSystems;
            request.compartmentId = this.compartmentId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timereleased("TIMERELEASED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

