/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAcceptedAgreementsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String displayName;
    private String listingId;
    private String packageVersion;
    private String acceptedAgreementId;
    private String opcRequestId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getAcceptedAgreementId() {
        return this.acceptedAgreementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).listingId(this.listingId).packageVersion(this.packageVersion).acceptedAgreementId(this.acceptedAgreementId).opcRequestId(this.opcRequestId).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",listingId=").append(String.valueOf(this.listingId));
        sb.append(",packageVersion=").append(String.valueOf(this.packageVersion));
        sb.append(",acceptedAgreementId=").append(String.valueOf(this.acceptedAgreementId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAcceptedAgreementsRequest)) {
            return false;
        }
        ListAcceptedAgreementsRequest other = (ListAcceptedAgreementsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.packageVersion, other.packageVersion) && Objects.equals(this.acceptedAgreementId, other.acceptedAgreementId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.packageVersion == null ? 43 : this.packageVersion.hashCode());
        result = result * 59 + (this.acceptedAgreementId == null ? 43 : this.acceptedAgreementId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAcceptedAgreementsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String displayName = null;
        private String listingId = null;
        private String packageVersion = null;
        private String acceptedAgreementId = null;
        private String opcRequestId = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public Builder acceptedAgreementId(String acceptedAgreementId) {
            this.acceptedAgreementId = acceptedAgreementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAcceptedAgreementsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.listingId(o.getListingId());
            this.packageVersion(o.getPackageVersion());
            this.acceptedAgreementId(o.getAcceptedAgreementId());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAcceptedAgreementsRequest build() {
            ListAcceptedAgreementsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAcceptedAgreementsRequest buildWithoutInvocationCallback() {
            ListAcceptedAgreementsRequest request = new ListAcceptedAgreementsRequest();
            request.compartmentId = this.compartmentId;
            request.displayName = this.displayName;
            request.listingId = this.listingId;
            request.packageVersion = this.packageVersion;
            request.acceptedAgreementId = this.acceptedAgreementId;
            request.opcRequestId = this.opcRequestId;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timeaccepted("TIMEACCEPTED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

