/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPublicationPackageRequest
extends BmcRequest<Void> {
    private String publicationId;
    private String packageVersion;
    private String opcRequestId;

    public String getPublicationId() {
        return this.publicationId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().publicationId(this.publicationId).packageVersion(this.packageVersion).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",publicationId=").append(String.valueOf(this.publicationId));
        sb.append(",packageVersion=").append(String.valueOf(this.packageVersion));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPublicationPackageRequest)) {
            return false;
        }
        GetPublicationPackageRequest other = (GetPublicationPackageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.publicationId, other.publicationId) && Objects.equals(this.packageVersion, other.packageVersion) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.publicationId == null ? 43 : this.publicationId.hashCode());
        result = result * 59 + (this.packageVersion == null ? 43 : this.packageVersion.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPublicationPackageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String publicationId = null;
        private String packageVersion = null;
        private String opcRequestId = null;

        public Builder publicationId(String publicationId) {
            this.publicationId = publicationId;
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublicationPackageRequest o) {
            this.publicationId(o.getPublicationId());
            this.packageVersion(o.getPackageVersion());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublicationPackageRequest build() {
            GetPublicationPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPublicationPackageRequest buildWithoutInvocationCallback() {
            GetPublicationPackageRequest request = new GetPublicationPackageRequest();
            request.publicationId = this.publicationId;
            request.packageVersion = this.packageVersion;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

