/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPackageRequest
extends BmcRequest<Void> {
    private String listingId;
    private String packageVersion;
    private String opcRequestId;
    private String compartmentId;

    public String getListingId() {
        return this.listingId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Builder toBuilder() {
        return new Builder().listingId(this.listingId).packageVersion(this.packageVersion).opcRequestId(this.opcRequestId).compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",listingId=").append(String.valueOf(this.listingId));
        sb.append(",packageVersion=").append(String.valueOf(this.packageVersion));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPackageRequest)) {
            return false;
        }
        GetPackageRequest other = (GetPackageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.packageVersion, other.packageVersion) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.packageVersion == null ? 43 : this.packageVersion.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPackageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String listingId = null;
        private String packageVersion = null;
        private String opcRequestId = null;
        private String compartmentId = null;

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPackageRequest o) {
            this.listingId(o.getListingId());
            this.packageVersion(o.getPackageVersion());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPackageRequest build() {
            GetPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPackageRequest buildWithoutInvocationCallback() {
            GetPackageRequest request = new GetPackageRequest();
            request.listingId = this.listingId;
            request.packageVersion = this.packageVersion;
            request.opcRequestId = this.opcRequestId;
            request.compartmentId = this.compartmentId;
            return request;
        }
    }
}

