/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAcceptedAgreementRequest
extends BmcRequest<Void> {
    private String acceptedAgreementId;
    private String opcRequestId;

    public String getAcceptedAgreementId() {
        return this.acceptedAgreementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().acceptedAgreementId(this.acceptedAgreementId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",acceptedAgreementId=").append(String.valueOf(this.acceptedAgreementId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAcceptedAgreementRequest)) {
            return false;
        }
        GetAcceptedAgreementRequest other = (GetAcceptedAgreementRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.acceptedAgreementId, other.acceptedAgreementId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.acceptedAgreementId == null ? 43 : this.acceptedAgreementId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAcceptedAgreementRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String acceptedAgreementId = null;
        private String opcRequestId = null;

        public Builder acceptedAgreementId(String acceptedAgreementId) {
            this.acceptedAgreementId = acceptedAgreementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAcceptedAgreementRequest o) {
            this.acceptedAgreementId(o.getAcceptedAgreementId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAcceptedAgreementRequest build() {
            GetAcceptedAgreementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAcceptedAgreementRequest buildWithoutInvocationCallback() {
            GetAcceptedAgreementRequest request = new GetAcceptedAgreementRequest();
            request.acceptedAgreementId = this.acceptedAgreementId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

