/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.marketplace.model.CreatePublicationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePublicationRequest
extends BmcRequest<CreatePublicationDetails> {
    private CreatePublicationDetails createPublicationDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreatePublicationDetails getCreatePublicationDetails() {
        return this.createPublicationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreatePublicationDetails getBody$() {
        return this.createPublicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().createPublicationDetails(this.createPublicationDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createPublicationDetails=").append(String.valueOf((Object)this.createPublicationDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePublicationRequest)) {
            return false;
        }
        CreatePublicationRequest other = (CreatePublicationRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createPublicationDetails, (Object)other.createPublicationDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createPublicationDetails == null ? 43 : this.createPublicationDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePublicationRequest, CreatePublicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreatePublicationDetails createPublicationDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createPublicationDetails(CreatePublicationDetails createPublicationDetails) {
            this.createPublicationDetails = createPublicationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePublicationRequest o) {
            this.createPublicationDetails(o.getCreatePublicationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePublicationRequest build() {
            CreatePublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePublicationDetails body) {
            this.createPublicationDetails(body);
            return this;
        }

        public CreatePublicationRequest buildWithoutInvocationCallback() {
            CreatePublicationRequest request = new CreatePublicationRequest();
            request.createPublicationDetails = this.createPublicationDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

