/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UploadData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="contentUrl")
    private final String contentUrl;
    @JsonProperty(value="mimeType")
    private final String mimeType;
    @JsonProperty(value="fileExtension")
    private final String fileExtension;

    @Deprecated
    @ConstructorProperties(value={"name", "contentUrl", "mimeType", "fileExtension"})
    public UploadData(String name, String contentUrl, String mimeType, String fileExtension) {
        this.name = name;
        this.contentUrl = contentUrl;
        this.mimeType = mimeType;
        this.fileExtension = fileExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UploadData(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", contentUrl=").append(String.valueOf(this.contentUrl));
        sb.append(", mimeType=").append(String.valueOf(this.mimeType));
        sb.append(", fileExtension=").append(String.valueOf(this.fileExtension));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadData)) {
            return false;
        }
        UploadData other = (UploadData)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.contentUrl, other.contentUrl) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.fileExtension, other.fileExtension) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.contentUrl == null ? 43 : this.contentUrl.hashCode());
        result = result * 59 + (this.mimeType == null ? 43 : this.mimeType.hashCode());
        result = result * 59 + (this.fileExtension == null ? 43 : this.fileExtension.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="contentUrl")
        private String contentUrl;
        @JsonProperty(value="mimeType")
        private String mimeType;
        @JsonProperty(value="fileExtension")
        private String fileExtension;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.__explicitlySet__.add("contentUrl");
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            this.__explicitlySet__.add("mimeType");
            return this;
        }

        public Builder fileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            this.__explicitlySet__.add("fileExtension");
            return this;
        }

        public UploadData build() {
            UploadData model = new UploadData(this.name, this.contentUrl, this.mimeType, this.fileExtension);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UploadData model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("contentUrl")) {
                this.contentUrl(model.getContentUrl());
            }
            if (model.wasPropertyExplicitlySet("mimeType")) {
                this.mimeType(model.getMimeType());
            }
            if (model.wasPropertyExplicitlySet("fileExtension")) {
                this.fileExtension(model.getFileExtension());
            }
            return this;
        }
    }
}

