/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ThirdPartyPaidListingEligibility
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isPaidListingEligible")
    private final Boolean isPaidListingEligible;
    @JsonProperty(value="isPaidListingThrottled")
    private final Boolean isPaidListingThrottled;
    @JsonProperty(value="eligibilityReason")
    private final EligibilityReason eligibilityReason;

    @Deprecated
    @ConstructorProperties(value={"isPaidListingEligible", "isPaidListingThrottled", "eligibilityReason"})
    public ThirdPartyPaidListingEligibility(Boolean isPaidListingEligible, Boolean isPaidListingThrottled, EligibilityReason eligibilityReason) {
        this.isPaidListingEligible = isPaidListingEligible;
        this.isPaidListingThrottled = isPaidListingThrottled;
        this.eligibilityReason = eligibilityReason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsPaidListingEligible() {
        return this.isPaidListingEligible;
    }

    public Boolean getIsPaidListingThrottled() {
        return this.isPaidListingThrottled;
    }

    public EligibilityReason getEligibilityReason() {
        return this.eligibilityReason;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ThirdPartyPaidListingEligibility(");
        sb.append("super=").append(super.toString());
        sb.append("isPaidListingEligible=").append(String.valueOf(this.isPaidListingEligible));
        sb.append(", isPaidListingThrottled=").append(String.valueOf(this.isPaidListingThrottled));
        sb.append(", eligibilityReason=").append(String.valueOf((Object)this.eligibilityReason));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThirdPartyPaidListingEligibility)) {
            return false;
        }
        ThirdPartyPaidListingEligibility other = (ThirdPartyPaidListingEligibility)((Object)o);
        return Objects.equals(this.isPaidListingEligible, other.isPaidListingEligible) && Objects.equals(this.isPaidListingThrottled, other.isPaidListingThrottled) && Objects.equals((Object)this.eligibilityReason, (Object)other.eligibilityReason) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPaidListingEligible == null ? 43 : this.isPaidListingEligible.hashCode());
        result = result * 59 + (this.isPaidListingThrottled == null ? 43 : this.isPaidListingThrottled.hashCode());
        result = result * 59 + (this.eligibilityReason == null ? 43 : this.eligibilityReason.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EligibilityReason implements BmcEnum
    {
        Eligible("ELIGIBLE"),
        IneligibleAccountCountry("INELIGIBLE_ACCOUNT_COUNTRY"),
        IneligibleRegion("INELIGIBLE_REGION"),
        IneligibleAccountBlacklisted("INELIGIBLE_ACCOUNT_BLACKLISTED"),
        IneligibleAccountFeatureDisabled("INELIGIBLE_ACCOUNT_FEATURE_DISABLED"),
        IneligibleAccountCurrency("INELIGIBLE_ACCOUNT_CURRENCY"),
        IneligibleAccountNotPaid("INELIGIBLE_ACCOUNT_NOT_PAID"),
        IneligibleAccountInternal("INELIGIBLE_ACCOUNT_INTERNAL"),
        IneligibleAccountGovSubscription("INELIGIBLE_ACCOUNT_GOV_SUBSCRIPTION"),
        NotAuthorized("NOT_AUTHORIZED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EligibilityReason> map;

        private EligibilityReason(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EligibilityReason create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EligibilityReason', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EligibilityReason.class);
            map = new HashMap<String, EligibilityReason>();
            for (EligibilityReason v : EligibilityReason.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isPaidListingEligible")
        private Boolean isPaidListingEligible;
        @JsonProperty(value="isPaidListingThrottled")
        private Boolean isPaidListingThrottled;
        @JsonProperty(value="eligibilityReason")
        private EligibilityReason eligibilityReason;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isPaidListingEligible(Boolean isPaidListingEligible) {
            this.isPaidListingEligible = isPaidListingEligible;
            this.__explicitlySet__.add("isPaidListingEligible");
            return this;
        }

        public Builder isPaidListingThrottled(Boolean isPaidListingThrottled) {
            this.isPaidListingThrottled = isPaidListingThrottled;
            this.__explicitlySet__.add("isPaidListingThrottled");
            return this;
        }

        public Builder eligibilityReason(EligibilityReason eligibilityReason) {
            this.eligibilityReason = eligibilityReason;
            this.__explicitlySet__.add("eligibilityReason");
            return this;
        }

        public ThirdPartyPaidListingEligibility build() {
            ThirdPartyPaidListingEligibility model = new ThirdPartyPaidListingEligibility(this.isPaidListingEligible, this.isPaidListingThrottled, this.eligibilityReason);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ThirdPartyPaidListingEligibility model) {
            if (model.wasPropertyExplicitlySet("isPaidListingEligible")) {
                this.isPaidListingEligible(model.getIsPaidListingEligible());
            }
            if (model.wasPropertyExplicitlySet("isPaidListingThrottled")) {
                this.isPaidListingThrottled(model.getIsPaidListingThrottled());
            }
            if (model.wasPropertyExplicitlySet("eligibilityReason")) {
                this.eligibilityReason(model.getEligibilityReason());
            }
            return this;
        }
    }
}

