/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReportSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="reportType")
    private final String reportType;
    @JsonProperty(value="date")
    private final Date date;
    @JsonProperty(value="columns")
    private final List<String> columns;
    @JsonProperty(value="content")
    private final String content;

    @Deprecated
    @ConstructorProperties(value={"reportType", "date", "columns", "content"})
    public ReportSummary(String reportType, Date date, List<String> columns, String content) {
        this.reportType = reportType;
        this.date = date;
        this.columns = columns;
        this.content = content;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getReportType() {
        return this.reportType;
    }

    public Date getDate() {
        return this.date;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportSummary(");
        sb.append("super=").append(super.toString());
        sb.append("reportType=").append(String.valueOf(this.reportType));
        sb.append(", date=").append(String.valueOf(this.date));
        sb.append(", columns=").append(String.valueOf(this.columns));
        sb.append(", content=").append(String.valueOf(this.content));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReportSummary)) {
            return false;
        }
        ReportSummary other = (ReportSummary)((Object)o);
        return Objects.equals(this.reportType, other.reportType) && Objects.equals(this.date, other.date) && Objects.equals(this.columns, other.columns) && Objects.equals(this.content, other.content) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reportType == null ? 43 : this.reportType.hashCode());
        result = result * 59 + (this.date == null ? 43 : this.date.hashCode());
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="reportType")
        private String reportType;
        @JsonProperty(value="date")
        private Date date;
        @JsonProperty(value="columns")
        private List<String> columns;
        @JsonProperty(value="content")
        private String content;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder reportType(String reportType) {
            this.reportType = reportType;
            this.__explicitlySet__.add("reportType");
            return this;
        }

        public Builder date(Date date) {
            this.date = date;
            this.__explicitlySet__.add("date");
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public ReportSummary build() {
            ReportSummary model = new ReportSummary(this.reportType, this.date, this.columns, this.content);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReportSummary model) {
            if (model.wasPropertyExplicitlySet("reportType")) {
                this.reportType(model.getReportType());
            }
            if (model.wasPropertyExplicitlySet("date")) {
                this.date(model.getDate());
            }
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            return this;
        }
    }
}

