/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.Link;
import com.oracle.bmc.marketplace.model.UploadData;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Publisher
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="yearFounded")
    private final Long yearFounded;
    @JsonProperty(value="websiteUrl")
    private final String websiteUrl;
    @JsonProperty(value="contactEmail")
    private final String contactEmail;
    @JsonProperty(value="contactPhone")
    private final String contactPhone;
    @JsonProperty(value="hqAddress")
    private final String hqAddress;
    @JsonProperty(value="logo")
    private final UploadData logo;
    @JsonProperty(value="links")
    private final List<Link> links;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "description", "yearFounded", "websiteUrl", "contactEmail", "contactPhone", "hqAddress", "logo", "links"})
    public Publisher(String id, String name, String description, Long yearFounded, String websiteUrl, String contactEmail, String contactPhone, String hqAddress, UploadData logo, List<Link> links) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.yearFounded = yearFounded;
        this.websiteUrl = websiteUrl;
        this.contactEmail = contactEmail;
        this.contactPhone = contactPhone;
        this.hqAddress = hqAddress;
        this.logo = logo;
        this.links = links;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getYearFounded() {
        return this.yearFounded;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public String getHqAddress() {
        return this.hqAddress;
    }

    public UploadData getLogo() {
        return this.logo;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Publisher(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", yearFounded=").append(String.valueOf(this.yearFounded));
        sb.append(", websiteUrl=").append(String.valueOf(this.websiteUrl));
        sb.append(", contactEmail=").append(String.valueOf(this.contactEmail));
        sb.append(", contactPhone=").append(String.valueOf(this.contactPhone));
        sb.append(", hqAddress=").append(String.valueOf(this.hqAddress));
        sb.append(", logo=").append(String.valueOf((Object)this.logo));
        sb.append(", links=").append(String.valueOf(this.links));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Publisher)) {
            return false;
        }
        Publisher other = (Publisher)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.yearFounded, other.yearFounded) && Objects.equals(this.websiteUrl, other.websiteUrl) && Objects.equals(this.contactEmail, other.contactEmail) && Objects.equals(this.contactPhone, other.contactPhone) && Objects.equals(this.hqAddress, other.hqAddress) && Objects.equals((Object)this.logo, (Object)other.logo) && Objects.equals(this.links, other.links) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.yearFounded == null ? 43 : this.yearFounded.hashCode());
        result = result * 59 + (this.websiteUrl == null ? 43 : this.websiteUrl.hashCode());
        result = result * 59 + (this.contactEmail == null ? 43 : this.contactEmail.hashCode());
        result = result * 59 + (this.contactPhone == null ? 43 : this.contactPhone.hashCode());
        result = result * 59 + (this.hqAddress == null ? 43 : this.hqAddress.hashCode());
        result = result * 59 + (this.logo == null ? 43 : this.logo.hashCode());
        result = result * 59 + (this.links == null ? 43 : this.links.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="yearFounded")
        private Long yearFounded;
        @JsonProperty(value="websiteUrl")
        private String websiteUrl;
        @JsonProperty(value="contactEmail")
        private String contactEmail;
        @JsonProperty(value="contactPhone")
        private String contactPhone;
        @JsonProperty(value="hqAddress")
        private String hqAddress;
        @JsonProperty(value="logo")
        private UploadData logo;
        @JsonProperty(value="links")
        private List<Link> links;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder yearFounded(Long yearFounded) {
            this.yearFounded = yearFounded;
            this.__explicitlySet__.add("yearFounded");
            return this;
        }

        public Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            this.__explicitlySet__.add("websiteUrl");
            return this;
        }

        public Builder contactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            this.__explicitlySet__.add("contactEmail");
            return this;
        }

        public Builder contactPhone(String contactPhone) {
            this.contactPhone = contactPhone;
            this.__explicitlySet__.add("contactPhone");
            return this;
        }

        public Builder hqAddress(String hqAddress) {
            this.hqAddress = hqAddress;
            this.__explicitlySet__.add("hqAddress");
            return this;
        }

        public Builder logo(UploadData logo) {
            this.logo = logo;
            this.__explicitlySet__.add("logo");
            return this;
        }

        public Builder links(List<Link> links) {
            this.links = links;
            this.__explicitlySet__.add("links");
            return this;
        }

        public Publisher build() {
            Publisher model = new Publisher(this.id, this.name, this.description, this.yearFounded, this.websiteUrl, this.contactEmail, this.contactPhone, this.hqAddress, this.logo, this.links);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Publisher model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("yearFounded")) {
                this.yearFounded(model.getYearFounded());
            }
            if (model.wasPropertyExplicitlySet("websiteUrl")) {
                this.websiteUrl(model.getWebsiteUrl());
            }
            if (model.wasPropertyExplicitlySet("contactEmail")) {
                this.contactEmail(model.getContactEmail());
            }
            if (model.wasPropertyExplicitlySet("contactPhone")) {
                this.contactPhone(model.getContactPhone());
            }
            if (model.wasPropertyExplicitlySet("hqAddress")) {
                this.hqAddress(model.getHqAddress());
            }
            if (model.wasPropertyExplicitlySet("logo")) {
                this.logo(model.getLogo());
            }
            if (model.wasPropertyExplicitlySet("links")) {
                this.links(model.getLinks());
            }
            return this;
        }
    }
}

