/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.ListingType;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import com.oracle.bmc.marketplace.model.PackageTypeEnum;
import com.oracle.bmc.marketplace.model.Publication;
import com.oracle.bmc.marketplace.model.UploadData;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PublicationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lifecycleState")
    private final Publication.LifecycleState lifecycleState;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="shortDescription")
    private final String shortDescription;
    @JsonProperty(value="icon")
    private final UploadData icon;
    @JsonProperty(value="packageType")
    private final PackageTypeEnum packageType;
    @JsonProperty(value="supportedOperatingSystems")
    private final List<OperatingSystem> supportedOperatingSystems;
    @JsonProperty(value="listingType")
    private final ListingType listingType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"lifecycleState", "compartmentId", "id", "name", "shortDescription", "icon", "packageType", "supportedOperatingSystems", "listingType", "timeCreated"})
    public PublicationSummary(Publication.LifecycleState lifecycleState, String compartmentId, String id, String name, String shortDescription, UploadData icon, PackageTypeEnum packageType, List<OperatingSystem> supportedOperatingSystems, ListingType listingType, Date timeCreated) {
        this.lifecycleState = lifecycleState;
        this.compartmentId = compartmentId;
        this.id = id;
        this.name = name;
        this.shortDescription = shortDescription;
        this.icon = icon;
        this.packageType = packageType;
        this.supportedOperatingSystems = supportedOperatingSystems;
        this.listingType = listingType;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Publication.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public UploadData getIcon() {
        return this.icon;
    }

    public PackageTypeEnum getPackageType() {
        return this.packageType;
    }

    public List<OperatingSystem> getSupportedOperatingSystems() {
        return this.supportedOperatingSystems;
    }

    public ListingType getListingType() {
        return this.listingType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PublicationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", shortDescription=").append(String.valueOf(this.shortDescription));
        sb.append(", icon=").append(String.valueOf((Object)this.icon));
        sb.append(", packageType=").append(String.valueOf((Object)this.packageType));
        sb.append(", supportedOperatingSystems=").append(String.valueOf(this.supportedOperatingSystems));
        sb.append(", listingType=").append(String.valueOf((Object)this.listingType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicationSummary)) {
            return false;
        }
        PublicationSummary other = (PublicationSummary)((Object)o);
        return Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.shortDescription, other.shortDescription) && Objects.equals((Object)this.icon, (Object)other.icon) && Objects.equals((Object)this.packageType, (Object)other.packageType) && Objects.equals(this.supportedOperatingSystems, other.supportedOperatingSystems) && Objects.equals((Object)this.listingType, (Object)other.listingType) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.shortDescription == null ? 43 : this.shortDescription.hashCode());
        result = result * 59 + (this.icon == null ? 43 : this.icon.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.supportedOperatingSystems == null ? 43 : this.supportedOperatingSystems.hashCode());
        result = result * 59 + (this.listingType == null ? 43 : this.listingType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lifecycleState")
        private Publication.LifecycleState lifecycleState;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="shortDescription")
        private String shortDescription;
        @JsonProperty(value="icon")
        private UploadData icon;
        @JsonProperty(value="packageType")
        private PackageTypeEnum packageType;
        @JsonProperty(value="supportedOperatingSystems")
        private List<OperatingSystem> supportedOperatingSystems;
        @JsonProperty(value="listingType")
        private ListingType listingType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lifecycleState(Publication.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            this.__explicitlySet__.add("shortDescription");
            return this;
        }

        public Builder icon(UploadData icon) {
            this.icon = icon;
            this.__explicitlySet__.add("icon");
            return this;
        }

        public Builder packageType(PackageTypeEnum packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder supportedOperatingSystems(List<OperatingSystem> supportedOperatingSystems) {
            this.supportedOperatingSystems = supportedOperatingSystems;
            this.__explicitlySet__.add("supportedOperatingSystems");
            return this;
        }

        public Builder listingType(ListingType listingType) {
            this.listingType = listingType;
            this.__explicitlySet__.add("listingType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public PublicationSummary build() {
            PublicationSummary model = new PublicationSummary(this.lifecycleState, this.compartmentId, this.id, this.name, this.shortDescription, this.icon, this.packageType, this.supportedOperatingSystems, this.listingType, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PublicationSummary model) {
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("shortDescription")) {
                this.shortDescription(model.getShortDescription());
            }
            if (model.wasPropertyExplicitlySet("icon")) {
                this.icon(model.getIcon());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("supportedOperatingSystems")) {
                this.supportedOperatingSystems(model.getSupportedOperatingSystems());
            }
            if (model.wasPropertyExplicitlySet("listingType")) {
                this.listingType(model.getListingType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

