/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.ImagePublicationPackage;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import com.oracle.bmc.marketplace.model.OrchestrationPublicationPackage;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageType", defaultImpl=PublicationPackage.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OrchestrationPublicationPackage.class, name="ORCHESTRATION"), @JsonSubTypes.Type(value=ImagePublicationPackage.class, name="IMAGE")})
@JsonFilter(value="explicitlySetFilter")
public class PublicationPackage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="listingId")
    private final String listingId;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="operatingSystem")
    private final OperatingSystem operatingSystem;

    @Deprecated
    @ConstructorProperties(value={"description", "listingId", "version", "resourceId", "timeCreated", "operatingSystem"})
    protected PublicationPackage(String description, String listingId, String version, String resourceId, Date timeCreated, OperatingSystem operatingSystem) {
        this.description = description;
        this.listingId = listingId;
        this.version = version;
        this.resourceId = resourceId;
        this.timeCreated = timeCreated;
        this.operatingSystem = operatingSystem;
    }

    public String getDescription() {
        return this.description;
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PublicationPackage(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", listingId=").append(String.valueOf(this.listingId));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", operatingSystem=").append(String.valueOf((Object)this.operatingSystem));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicationPackage)) {
            return false;
        }
        PublicationPackage other = (PublicationPackage)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.version, other.version) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.operatingSystem, (Object)other.operatingSystem) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }
}

