/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.marketplace.model.ListingType;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import com.oracle.bmc.marketplace.model.PackageTypeEnum;
import com.oracle.bmc.marketplace.model.SupportContact;
import com.oracle.bmc.marketplace.model.UploadData;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Publication
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="shortDescription")
    private final String shortDescription;
    @JsonProperty(value="longDescription")
    private final String longDescription;
    @JsonProperty(value="supportContacts")
    private final List<SupportContact> supportContacts;
    @JsonProperty(value="icon")
    private final UploadData icon;
    @JsonProperty(value="packageType")
    private final PackageTypeEnum packageType;
    @JsonProperty(value="listingType")
    private final ListingType listingType;
    @JsonProperty(value="supportedOperatingSystems")
    private final List<OperatingSystem> supportedOperatingSystems;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;

    @Deprecated
    @ConstructorProperties(value={"lifecycleState", "compartmentId", "id", "name", "shortDescription", "longDescription", "supportContacts", "icon", "packageType", "listingType", "supportedOperatingSystems", "timeCreated", "definedTags", "freeformTags"})
    public Publication(LifecycleState lifecycleState, String compartmentId, String id, String name, String shortDescription, String longDescription, List<SupportContact> supportContacts, UploadData icon, PackageTypeEnum packageType, ListingType listingType, List<OperatingSystem> supportedOperatingSystems, Date timeCreated, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags) {
        this.lifecycleState = lifecycleState;
        this.compartmentId = compartmentId;
        this.id = id;
        this.name = name;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.supportContacts = supportContacts;
        this.icon = icon;
        this.packageType = packageType;
        this.listingType = listingType;
        this.supportedOperatingSystems = supportedOperatingSystems;
        this.timeCreated = timeCreated;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public List<SupportContact> getSupportContacts() {
        return this.supportContacts;
    }

    public UploadData getIcon() {
        return this.icon;
    }

    public PackageTypeEnum getPackageType() {
        return this.packageType;
    }

    public ListingType getListingType() {
        return this.listingType;
    }

    public List<OperatingSystem> getSupportedOperatingSystems() {
        return this.supportedOperatingSystems;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Publication(");
        sb.append("super=").append(super.toString());
        sb.append("lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", shortDescription=").append(String.valueOf(this.shortDescription));
        sb.append(", longDescription=").append(String.valueOf(this.longDescription));
        sb.append(", supportContacts=").append(String.valueOf(this.supportContacts));
        sb.append(", icon=").append(String.valueOf((Object)this.icon));
        sb.append(", packageType=").append(String.valueOf((Object)this.packageType));
        sb.append(", listingType=").append(String.valueOf((Object)this.listingType));
        sb.append(", supportedOperatingSystems=").append(String.valueOf(this.supportedOperatingSystems));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Publication)) {
            return false;
        }
        Publication other = (Publication)((Object)o);
        return Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.shortDescription, other.shortDescription) && Objects.equals(this.longDescription, other.longDescription) && Objects.equals(this.supportContacts, other.supportContacts) && Objects.equals((Object)this.icon, (Object)other.icon) && Objects.equals((Object)this.packageType, (Object)other.packageType) && Objects.equals((Object)this.listingType, (Object)other.listingType) && Objects.equals(this.supportedOperatingSystems, other.supportedOperatingSystems) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.shortDescription == null ? 43 : this.shortDescription.hashCode());
        result = result * 59 + (this.longDescription == null ? 43 : this.longDescription.hashCode());
        result = result * 59 + (this.supportContacts == null ? 43 : this.supportContacts.hashCode());
        result = result * 59 + (this.icon == null ? 43 : this.icon.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.listingType == null ? 43 : this.listingType.hashCode());
        result = result * 59 + (this.supportedOperatingSystems == null ? 43 : this.supportedOperatingSystems.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="shortDescription")
        private String shortDescription;
        @JsonProperty(value="longDescription")
        private String longDescription;
        @JsonProperty(value="supportContacts")
        private List<SupportContact> supportContacts;
        @JsonProperty(value="icon")
        private UploadData icon;
        @JsonProperty(value="packageType")
        private PackageTypeEnum packageType;
        @JsonProperty(value="listingType")
        private ListingType listingType;
        @JsonProperty(value="supportedOperatingSystems")
        private List<OperatingSystem> supportedOperatingSystems;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            this.__explicitlySet__.add("shortDescription");
            return this;
        }

        public Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            this.__explicitlySet__.add("longDescription");
            return this;
        }

        public Builder supportContacts(List<SupportContact> supportContacts) {
            this.supportContacts = supportContacts;
            this.__explicitlySet__.add("supportContacts");
            return this;
        }

        public Builder icon(UploadData icon) {
            this.icon = icon;
            this.__explicitlySet__.add("icon");
            return this;
        }

        public Builder packageType(PackageTypeEnum packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder listingType(ListingType listingType) {
            this.listingType = listingType;
            this.__explicitlySet__.add("listingType");
            return this;
        }

        public Builder supportedOperatingSystems(List<OperatingSystem> supportedOperatingSystems) {
            this.supportedOperatingSystems = supportedOperatingSystems;
            this.__explicitlySet__.add("supportedOperatingSystems");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Publication build() {
            Publication model = new Publication(this.lifecycleState, this.compartmentId, this.id, this.name, this.shortDescription, this.longDescription, this.supportContacts, this.icon, this.packageType, this.listingType, this.supportedOperatingSystems, this.timeCreated, this.definedTags, this.freeformTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Publication model) {
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("shortDescription")) {
                this.shortDescription(model.getShortDescription());
            }
            if (model.wasPropertyExplicitlySet("longDescription")) {
                this.longDescription(model.getLongDescription());
            }
            if (model.wasPropertyExplicitlySet("supportContacts")) {
                this.supportContacts(model.getSupportContacts());
            }
            if (model.wasPropertyExplicitlySet("icon")) {
                this.icon(model.getIcon());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("listingType")) {
                this.listingType(model.getListingType());
            }
            if (model.wasPropertyExplicitlySet("supportedOperatingSystems")) {
                this.supportedOperatingSystems(model.getSupportedOperatingSystems());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            return this;
        }
    }
}

