/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.InternationalMarketPrice;
import com.oracle.bmc.marketplace.model.PricingCurrencyEnum;
import com.oracle.bmc.marketplace.model.PricingStrategyEnum;
import com.oracle.bmc.marketplace.model.PricingTypeEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PricingModel
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final PricingTypeEnum type;
    @JsonProperty(value="payGoStrategy")
    private final PricingStrategyEnum payGoStrategy;
    @JsonProperty(value="currency")
    private final PricingCurrencyEnum currency;
    @JsonProperty(value="rate")
    private final BigDecimal rate;
    @JsonProperty(value="internationalMarketPrice")
    private final InternationalMarketPrice internationalMarketPrice;

    @Deprecated
    @ConstructorProperties(value={"type", "payGoStrategy", "currency", "rate", "internationalMarketPrice"})
    public PricingModel(PricingTypeEnum type, PricingStrategyEnum payGoStrategy, PricingCurrencyEnum currency, BigDecimal rate, InternationalMarketPrice internationalMarketPrice) {
        this.type = type;
        this.payGoStrategy = payGoStrategy;
        this.currency = currency;
        this.rate = rate;
        this.internationalMarketPrice = internationalMarketPrice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public PricingTypeEnum getType() {
        return this.type;
    }

    public PricingStrategyEnum getPayGoStrategy() {
        return this.payGoStrategy;
    }

    public PricingCurrencyEnum getCurrency() {
        return this.currency;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public InternationalMarketPrice getInternationalMarketPrice() {
        return this.internationalMarketPrice;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PricingModel(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf((Object)this.type));
        sb.append(", payGoStrategy=").append(String.valueOf((Object)this.payGoStrategy));
        sb.append(", currency=").append(String.valueOf((Object)this.currency));
        sb.append(", rate=").append(String.valueOf(this.rate));
        sb.append(", internationalMarketPrice=").append(String.valueOf((Object)this.internationalMarketPrice));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PricingModel)) {
            return false;
        }
        PricingModel other = (PricingModel)((Object)o);
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.payGoStrategy, (Object)other.payGoStrategy) && Objects.equals((Object)this.currency, (Object)other.currency) && Objects.equals(this.rate, other.rate) && Objects.equals((Object)this.internationalMarketPrice, (Object)other.internationalMarketPrice) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.payGoStrategy == null ? 43 : this.payGoStrategy.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + (this.rate == null ? 43 : this.rate.hashCode());
        result = result * 59 + (this.internationalMarketPrice == null ? 43 : this.internationalMarketPrice.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private PricingTypeEnum type;
        @JsonProperty(value="payGoStrategy")
        private PricingStrategyEnum payGoStrategy;
        @JsonProperty(value="currency")
        private PricingCurrencyEnum currency;
        @JsonProperty(value="rate")
        private BigDecimal rate;
        @JsonProperty(value="internationalMarketPrice")
        private InternationalMarketPrice internationalMarketPrice;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(PricingTypeEnum type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder payGoStrategy(PricingStrategyEnum payGoStrategy) {
            this.payGoStrategy = payGoStrategy;
            this.__explicitlySet__.add("payGoStrategy");
            return this;
        }

        public Builder currency(PricingCurrencyEnum currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public Builder rate(BigDecimal rate) {
            this.rate = rate;
            this.__explicitlySet__.add("rate");
            return this;
        }

        public Builder internationalMarketPrice(InternationalMarketPrice internationalMarketPrice) {
            this.internationalMarketPrice = internationalMarketPrice;
            this.__explicitlySet__.add("internationalMarketPrice");
            return this;
        }

        public PricingModel build() {
            PricingModel model = new PricingModel(this.type, this.payGoStrategy, this.currency, this.rate, this.internationalMarketPrice);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PricingModel model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("payGoStrategy")) {
                this.payGoStrategy(model.getPayGoStrategy());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            if (model.wasPropertyExplicitlySet("rate")) {
                this.rate(model.getRate());
            }
            if (model.wasPropertyExplicitlySet("internationalMarketPrice")) {
                this.internationalMarketPrice(model.getInternationalMarketPrice());
            }
            return this;
        }
    }
}

