/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.OrchestrationVariableTypeEnum;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OrchestrationVariable
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="dataType")
    private final OrchestrationVariableTypeEnum dataType;
    @JsonProperty(value="isMandatory")
    private final Boolean isMandatory;
    @JsonProperty(value="hintMessage")
    private final String hintMessage;

    @Deprecated
    @ConstructorProperties(value={"name", "defaultValue", "description", "dataType", "isMandatory", "hintMessage"})
    public OrchestrationVariable(String name, String defaultValue, String description, OrchestrationVariableTypeEnum dataType, Boolean isMandatory, String hintMessage) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        this.dataType = dataType;
        this.isMandatory = isMandatory;
        this.hintMessage = hintMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public OrchestrationVariableTypeEnum getDataType() {
        return this.dataType;
    }

    public Boolean getIsMandatory() {
        return this.isMandatory;
    }

    public String getHintMessage() {
        return this.hintMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OrchestrationVariable(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", dataType=").append(String.valueOf((Object)this.dataType));
        sb.append(", isMandatory=").append(String.valueOf(this.isMandatory));
        sb.append(", hintMessage=").append(String.valueOf(this.hintMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrchestrationVariable)) {
            return false;
        }
        OrchestrationVariable other = (OrchestrationVariable)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.dataType, (Object)other.dataType) && Objects.equals(this.isMandatory, other.isMandatory) && Objects.equals(this.hintMessage, other.hintMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.isMandatory == null ? 43 : this.isMandatory.hashCode());
        result = result * 59 + (this.hintMessage == null ? 43 : this.hintMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dataType")
        private OrchestrationVariableTypeEnum dataType;
        @JsonProperty(value="isMandatory")
        private Boolean isMandatory;
        @JsonProperty(value="hintMessage")
        private String hintMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder dataType(OrchestrationVariableTypeEnum dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.__explicitlySet__.add("isMandatory");
            return this;
        }

        public Builder hintMessage(String hintMessage) {
            this.hintMessage = hintMessage;
            this.__explicitlySet__.add("hintMessage");
            return this;
        }

        public OrchestrationVariable build() {
            OrchestrationVariable model = new OrchestrationVariable(this.name, this.defaultValue, this.description, this.dataType, this.isMandatory, this.hintMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OrchestrationVariable model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("isMandatory")) {
                this.isMandatory(model.getIsMandatory());
            }
            if (model.wasPropertyExplicitlySet("hintMessage")) {
                this.hintMessage(model.getHintMessage());
            }
            return this;
        }
    }
}

