/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import com.oracle.bmc.marketplace.model.OrchestrationVariable;
import com.oracle.bmc.marketplace.model.PublicationPackage;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageType")
@JsonFilter(value="explicitlySetFilter")
public final class OrchestrationPublicationPackage
extends PublicationPackage {
    @JsonProperty(value="resourceLink")
    private final String resourceLink;
    @JsonProperty(value="variables")
    private final List<OrchestrationVariable> variables;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OrchestrationPublicationPackage(String description, String listingId, String version, String resourceId, Date timeCreated, OperatingSystem operatingSystem, String resourceLink, List<OrchestrationVariable> variables) {
        super(description, listingId, version, resourceId, timeCreated, operatingSystem);
        this.resourceLink = resourceLink;
        this.variables = variables;
    }

    public String getResourceLink() {
        return this.resourceLink;
    }

    public List<OrchestrationVariable> getVariables() {
        return this.variables;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OrchestrationPublicationPackage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", resourceLink=").append(String.valueOf(this.resourceLink));
        sb.append(", variables=").append(String.valueOf(this.variables));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrchestrationPublicationPackage)) {
            return false;
        }
        OrchestrationPublicationPackage other = (OrchestrationPublicationPackage)((Object)o);
        return Objects.equals(this.resourceLink, other.resourceLink) && Objects.equals(this.variables, other.variables) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resourceLink == null ? 43 : this.resourceLink.hashCode());
        result = result * 59 + (this.variables == null ? 43 : this.variables.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="resourceLink")
        private String resourceLink;
        @JsonProperty(value="variables")
        private List<OrchestrationVariable> variables;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder resourceLink(String resourceLink) {
            this.resourceLink = resourceLink;
            this.__explicitlySet__.add("resourceLink");
            return this;
        }

        public Builder variables(List<OrchestrationVariable> variables) {
            this.variables = variables;
            this.__explicitlySet__.add("variables");
            return this;
        }

        public OrchestrationPublicationPackage build() {
            OrchestrationPublicationPackage model = new OrchestrationPublicationPackage(this.description, this.listingId, this.version, this.resourceId, this.timeCreated, this.operatingSystem, this.resourceLink, this.variables);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OrchestrationPublicationPackage model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("resourceLink")) {
                this.resourceLink(model.getResourceLink());
            }
            if (model.wasPropertyExplicitlySet("variables")) {
                this.variables(model.getVariables());
            }
            return this;
        }
    }
}

