/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.marketplace.model.ListingType;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import com.oracle.bmc.marketplace.model.PackageTypeEnum;
import com.oracle.bmc.marketplace.model.PublisherSummary;
import com.oracle.bmc.marketplace.model.Region;
import com.oracle.bmc.marketplace.model.UploadData;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ListingSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="shortDescription")
    private final String shortDescription;
    @JsonProperty(value="isRoverExportable")
    private final Boolean isRoverExportable;
    @JsonProperty(value="tagline")
    private final String tagline;
    @JsonProperty(value="icon")
    private final UploadData icon;
    @JsonProperty(value="packageType")
    private final PackageTypeEnum packageType;
    @JsonProperty(value="pricingTypes")
    private final List<PricingTypes> pricingTypes;
    @JsonProperty(value="compatibleArchitectures")
    private final List<CompatibleArchitectures> compatibleArchitectures;
    @JsonProperty(value="regions")
    private final List<Region> regions;
    @JsonProperty(value="isFeatured")
    private final Boolean isFeatured;
    @JsonProperty(value="categories")
    private final List<String> categories;
    @JsonProperty(value="publisher")
    private final PublisherSummary publisher;
    @JsonProperty(value="supportedOperatingSystems")
    private final List<OperatingSystem> supportedOperatingSystems;
    @JsonProperty(value="listingType")
    private final ListingType listingType;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "shortDescription", "isRoverExportable", "tagline", "icon", "packageType", "pricingTypes", "compatibleArchitectures", "regions", "isFeatured", "categories", "publisher", "supportedOperatingSystems", "listingType"})
    public ListingSummary(String id, String name, String shortDescription, Boolean isRoverExportable, String tagline, UploadData icon, PackageTypeEnum packageType, List<PricingTypes> pricingTypes, List<CompatibleArchitectures> compatibleArchitectures, List<Region> regions, Boolean isFeatured, List<String> categories, PublisherSummary publisher, List<OperatingSystem> supportedOperatingSystems, ListingType listingType) {
        this.id = id;
        this.name = name;
        this.shortDescription = shortDescription;
        this.isRoverExportable = isRoverExportable;
        this.tagline = tagline;
        this.icon = icon;
        this.packageType = packageType;
        this.pricingTypes = pricingTypes;
        this.compatibleArchitectures = compatibleArchitectures;
        this.regions = regions;
        this.isFeatured = isFeatured;
        this.categories = categories;
        this.publisher = publisher;
        this.supportedOperatingSystems = supportedOperatingSystems;
        this.listingType = listingType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Boolean getIsRoverExportable() {
        return this.isRoverExportable;
    }

    public String getTagline() {
        return this.tagline;
    }

    public UploadData getIcon() {
        return this.icon;
    }

    public PackageTypeEnum getPackageType() {
        return this.packageType;
    }

    public List<PricingTypes> getPricingTypes() {
        return this.pricingTypes;
    }

    public List<CompatibleArchitectures> getCompatibleArchitectures() {
        return this.compatibleArchitectures;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public Boolean getIsFeatured() {
        return this.isFeatured;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public PublisherSummary getPublisher() {
        return this.publisher;
    }

    public List<OperatingSystem> getSupportedOperatingSystems() {
        return this.supportedOperatingSystems;
    }

    public ListingType getListingType() {
        return this.listingType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ListingSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", shortDescription=").append(String.valueOf(this.shortDescription));
        sb.append(", isRoverExportable=").append(String.valueOf(this.isRoverExportable));
        sb.append(", tagline=").append(String.valueOf(this.tagline));
        sb.append(", icon=").append(String.valueOf((Object)this.icon));
        sb.append(", packageType=").append(String.valueOf((Object)this.packageType));
        sb.append(", pricingTypes=").append(String.valueOf(this.pricingTypes));
        sb.append(", compatibleArchitectures=").append(String.valueOf(this.compatibleArchitectures));
        sb.append(", regions=").append(String.valueOf(this.regions));
        sb.append(", isFeatured=").append(String.valueOf(this.isFeatured));
        sb.append(", categories=").append(String.valueOf(this.categories));
        sb.append(", publisher=").append(String.valueOf((Object)this.publisher));
        sb.append(", supportedOperatingSystems=").append(String.valueOf(this.supportedOperatingSystems));
        sb.append(", listingType=").append(String.valueOf((Object)this.listingType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListingSummary)) {
            return false;
        }
        ListingSummary other = (ListingSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.shortDescription, other.shortDescription) && Objects.equals(this.isRoverExportable, other.isRoverExportable) && Objects.equals(this.tagline, other.tagline) && Objects.equals((Object)this.icon, (Object)other.icon) && Objects.equals((Object)this.packageType, (Object)other.packageType) && Objects.equals(this.pricingTypes, other.pricingTypes) && Objects.equals(this.compatibleArchitectures, other.compatibleArchitectures) && Objects.equals(this.regions, other.regions) && Objects.equals(this.isFeatured, other.isFeatured) && Objects.equals(this.categories, other.categories) && Objects.equals((Object)this.publisher, (Object)other.publisher) && Objects.equals(this.supportedOperatingSystems, other.supportedOperatingSystems) && Objects.equals((Object)this.listingType, (Object)other.listingType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.shortDescription == null ? 43 : this.shortDescription.hashCode());
        result = result * 59 + (this.isRoverExportable == null ? 43 : this.isRoverExportable.hashCode());
        result = result * 59 + (this.tagline == null ? 43 : this.tagline.hashCode());
        result = result * 59 + (this.icon == null ? 43 : this.icon.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.pricingTypes == null ? 43 : this.pricingTypes.hashCode());
        result = result * 59 + (this.compatibleArchitectures == null ? 43 : this.compatibleArchitectures.hashCode());
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + (this.isFeatured == null ? 43 : this.isFeatured.hashCode());
        result = result * 59 + (this.categories == null ? 43 : this.categories.hashCode());
        result = result * 59 + (this.publisher == null ? 43 : this.publisher.hashCode());
        result = result * 59 + (this.supportedOperatingSystems == null ? 43 : this.supportedOperatingSystems.hashCode());
        result = result * 59 + (this.listingType == null ? 43 : this.listingType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CompatibleArchitectures implements BmcEnum
    {
        X86("X86"),
        Arm("ARM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CompatibleArchitectures> map;

        private CompatibleArchitectures(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CompatibleArchitectures create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CompatibleArchitectures', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CompatibleArchitectures.class);
            map = new HashMap<String, CompatibleArchitectures>();
            for (CompatibleArchitectures v : CompatibleArchitectures.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PricingTypes implements BmcEnum
    {
        Free("FREE"),
        Byol("BYOL"),
        Paygo("PAYGO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PricingTypes> map;

        private PricingTypes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PricingTypes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PricingTypes', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PricingTypes.class);
            map = new HashMap<String, PricingTypes>();
            for (PricingTypes v : PricingTypes.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="shortDescription")
        private String shortDescription;
        @JsonProperty(value="isRoverExportable")
        private Boolean isRoverExportable;
        @JsonProperty(value="tagline")
        private String tagline;
        @JsonProperty(value="icon")
        private UploadData icon;
        @JsonProperty(value="packageType")
        private PackageTypeEnum packageType;
        @JsonProperty(value="pricingTypes")
        private List<PricingTypes> pricingTypes;
        @JsonProperty(value="compatibleArchitectures")
        private List<CompatibleArchitectures> compatibleArchitectures;
        @JsonProperty(value="regions")
        private List<Region> regions;
        @JsonProperty(value="isFeatured")
        private Boolean isFeatured;
        @JsonProperty(value="categories")
        private List<String> categories;
        @JsonProperty(value="publisher")
        private PublisherSummary publisher;
        @JsonProperty(value="supportedOperatingSystems")
        private List<OperatingSystem> supportedOperatingSystems;
        @JsonProperty(value="listingType")
        private ListingType listingType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            this.__explicitlySet__.add("shortDescription");
            return this;
        }

        public Builder isRoverExportable(Boolean isRoverExportable) {
            this.isRoverExportable = isRoverExportable;
            this.__explicitlySet__.add("isRoverExportable");
            return this;
        }

        public Builder tagline(String tagline) {
            this.tagline = tagline;
            this.__explicitlySet__.add("tagline");
            return this;
        }

        public Builder icon(UploadData icon) {
            this.icon = icon;
            this.__explicitlySet__.add("icon");
            return this;
        }

        public Builder packageType(PackageTypeEnum packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder pricingTypes(List<PricingTypes> pricingTypes) {
            this.pricingTypes = pricingTypes;
            this.__explicitlySet__.add("pricingTypes");
            return this;
        }

        public Builder compatibleArchitectures(List<CompatibleArchitectures> compatibleArchitectures) {
            this.compatibleArchitectures = compatibleArchitectures;
            this.__explicitlySet__.add("compatibleArchitectures");
            return this;
        }

        public Builder regions(List<Region> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.__explicitlySet__.add("isFeatured");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.__explicitlySet__.add("categories");
            return this;
        }

        public Builder publisher(PublisherSummary publisher) {
            this.publisher = publisher;
            this.__explicitlySet__.add("publisher");
            return this;
        }

        public Builder supportedOperatingSystems(List<OperatingSystem> supportedOperatingSystems) {
            this.supportedOperatingSystems = supportedOperatingSystems;
            this.__explicitlySet__.add("supportedOperatingSystems");
            return this;
        }

        public Builder listingType(ListingType listingType) {
            this.listingType = listingType;
            this.__explicitlySet__.add("listingType");
            return this;
        }

        public ListingSummary build() {
            ListingSummary model = new ListingSummary(this.id, this.name, this.shortDescription, this.isRoverExportable, this.tagline, this.icon, this.packageType, this.pricingTypes, this.compatibleArchitectures, this.regions, this.isFeatured, this.categories, this.publisher, this.supportedOperatingSystems, this.listingType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ListingSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("shortDescription")) {
                this.shortDescription(model.getShortDescription());
            }
            if (model.wasPropertyExplicitlySet("isRoverExportable")) {
                this.isRoverExportable(model.getIsRoverExportable());
            }
            if (model.wasPropertyExplicitlySet("tagline")) {
                this.tagline(model.getTagline());
            }
            if (model.wasPropertyExplicitlySet("icon")) {
                this.icon(model.getIcon());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("pricingTypes")) {
                this.pricingTypes(model.getPricingTypes());
            }
            if (model.wasPropertyExplicitlySet("compatibleArchitectures")) {
                this.compatibleArchitectures(model.getCompatibleArchitectures());
            }
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            if (model.wasPropertyExplicitlySet("isFeatured")) {
                this.isFeatured(model.getIsFeatured());
            }
            if (model.wasPropertyExplicitlySet("categories")) {
                this.categories(model.getCategories());
            }
            if (model.wasPropertyExplicitlySet("publisher")) {
                this.publisher(model.getPublisher());
            }
            if (model.wasPropertyExplicitlySet("supportedOperatingSystems")) {
                this.supportedOperatingSystems(model.getSupportedOperatingSystems());
            }
            if (model.wasPropertyExplicitlySet("listingType")) {
                this.listingType(model.getListingType());
            }
            return this;
        }
    }
}

