/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.PackageTypeEnum;
import com.oracle.bmc.marketplace.model.PricingModel;
import com.oracle.bmc.marketplace.model.Region;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ListingPackageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="listingId")
    private final String listingId;
    @JsonProperty(value="packageVersion")
    private final String packageVersion;
    @JsonProperty(value="packageType")
    private final PackageTypeEnum packageType;
    @JsonProperty(value="pricing")
    private final PricingModel pricing;
    @JsonProperty(value="regions")
    private final List<Region> regions;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"listingId", "packageVersion", "packageType", "pricing", "regions", "resourceId", "timeCreated"})
    public ListingPackageSummary(String listingId, String packageVersion, PackageTypeEnum packageType, PricingModel pricing, List<Region> regions, String resourceId, Date timeCreated) {
        this.listingId = listingId;
        this.packageVersion = packageVersion;
        this.packageType = packageType;
        this.pricing = pricing;
        this.regions = regions;
        this.resourceId = resourceId;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public PackageTypeEnum getPackageType() {
        return this.packageType;
    }

    public PricingModel getPricing() {
        return this.pricing;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ListingPackageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("listingId=").append(String.valueOf(this.listingId));
        sb.append(", packageVersion=").append(String.valueOf(this.packageVersion));
        sb.append(", packageType=").append(String.valueOf((Object)this.packageType));
        sb.append(", pricing=").append(String.valueOf((Object)this.pricing));
        sb.append(", regions=").append(String.valueOf(this.regions));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListingPackageSummary)) {
            return false;
        }
        ListingPackageSummary other = (ListingPackageSummary)((Object)o);
        return Objects.equals(this.listingId, other.listingId) && Objects.equals(this.packageVersion, other.packageVersion) && Objects.equals((Object)this.packageType, (Object)other.packageType) && Objects.equals((Object)this.pricing, (Object)other.pricing) && Objects.equals(this.regions, other.regions) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.packageVersion == null ? 43 : this.packageVersion.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.pricing == null ? 43 : this.pricing.hashCode());
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="packageVersion")
        private String packageVersion;
        @JsonProperty(value="packageType")
        private PackageTypeEnum packageType;
        @JsonProperty(value="pricing")
        private PricingModel pricing;
        @JsonProperty(value="regions")
        private List<Region> regions;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            this.__explicitlySet__.add("packageVersion");
            return this;
        }

        public Builder packageType(PackageTypeEnum packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder pricing(PricingModel pricing) {
            this.pricing = pricing;
            this.__explicitlySet__.add("pricing");
            return this;
        }

        public Builder regions(List<Region> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public ListingPackageSummary build() {
            ListingPackageSummary model = new ListingPackageSummary(this.listingId, this.packageVersion, this.packageType, this.pricing, this.regions, this.resourceId, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ListingPackageSummary model) {
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("packageVersion")) {
                this.packageVersion(model.getPackageVersion());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("pricing")) {
                this.pricing(model.getPricing());
            }
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

