/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.PricingCurrencyEnum;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InternationalMarketPrice
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currencyCode")
    private final PricingCurrencyEnum currencyCode;
    @JsonProperty(value="currencySymbol")
    private final String currencySymbol;
    @JsonProperty(value="rate")
    private final Double rate;

    @Deprecated
    @ConstructorProperties(value={"currencyCode", "currencySymbol", "rate"})
    public InternationalMarketPrice(PricingCurrencyEnum currencyCode, String currencySymbol, Double rate) {
        this.currencyCode = currencyCode;
        this.currencySymbol = currencySymbol;
        this.rate = rate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public PricingCurrencyEnum getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public Double getRate() {
        return this.rate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InternationalMarketPrice(");
        sb.append("super=").append(super.toString());
        sb.append("currencyCode=").append(String.valueOf((Object)this.currencyCode));
        sb.append(", currencySymbol=").append(String.valueOf(this.currencySymbol));
        sb.append(", rate=").append(String.valueOf(this.rate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternationalMarketPrice)) {
            return false;
        }
        InternationalMarketPrice other = (InternationalMarketPrice)((Object)o);
        return Objects.equals((Object)this.currencyCode, (Object)other.currencyCode) && Objects.equals(this.currencySymbol, other.currencySymbol) && Objects.equals(this.rate, other.rate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currencyCode == null ? 43 : this.currencyCode.hashCode());
        result = result * 59 + (this.currencySymbol == null ? 43 : this.currencySymbol.hashCode());
        result = result * 59 + (this.rate == null ? 43 : this.rate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currencyCode")
        private PricingCurrencyEnum currencyCode;
        @JsonProperty(value="currencySymbol")
        private String currencySymbol;
        @JsonProperty(value="rate")
        private Double rate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currencyCode(PricingCurrencyEnum currencyCode) {
            this.currencyCode = currencyCode;
            this.__explicitlySet__.add("currencyCode");
            return this;
        }

        public Builder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            this.__explicitlySet__.add("currencySymbol");
            return this;
        }

        public Builder rate(Double rate) {
            this.rate = rate;
            this.__explicitlySet__.add("rate");
            return this;
        }

        public InternationalMarketPrice build() {
            InternationalMarketPrice model = new InternationalMarketPrice(this.currencyCode, this.currencySymbol, this.rate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InternationalMarketPrice model) {
            if (model.wasPropertyExplicitlySet("currencyCode")) {
                this.currencyCode(model.getCurrencyCode());
            }
            if (model.wasPropertyExplicitlySet("currencySymbol")) {
                this.currencySymbol(model.getCurrencySymbol());
            }
            if (model.wasPropertyExplicitlySet("rate")) {
                this.rate(model.getRate());
            }
            return this;
        }
    }
}

