/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import com.oracle.bmc.marketplace.model.PublicationPackage;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageType")
@JsonFilter(value="explicitlySetFilter")
public final class ImagePublicationPackage
extends PublicationPackage {
    @JsonProperty(value="appCatalogListingId")
    private final String appCatalogListingId;
    @JsonProperty(value="appCatalogListingResourceVersion")
    private final String appCatalogListingResourceVersion;
    @JsonProperty(value="imageId")
    private final String imageId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ImagePublicationPackage(String description, String listingId, String version, String resourceId, Date timeCreated, OperatingSystem operatingSystem, String appCatalogListingId, String appCatalogListingResourceVersion, String imageId) {
        super(description, listingId, version, resourceId, timeCreated, operatingSystem);
        this.appCatalogListingId = appCatalogListingId;
        this.appCatalogListingResourceVersion = appCatalogListingResourceVersion;
        this.imageId = imageId;
    }

    public String getAppCatalogListingId() {
        return this.appCatalogListingId;
    }

    public String getAppCatalogListingResourceVersion() {
        return this.appCatalogListingResourceVersion;
    }

    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImagePublicationPackage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", appCatalogListingId=").append(String.valueOf(this.appCatalogListingId));
        sb.append(", appCatalogListingResourceVersion=").append(String.valueOf(this.appCatalogListingResourceVersion));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImagePublicationPackage)) {
            return false;
        }
        ImagePublicationPackage other = (ImagePublicationPackage)((Object)o);
        return Objects.equals(this.appCatalogListingId, other.appCatalogListingId) && Objects.equals(this.appCatalogListingResourceVersion, other.appCatalogListingResourceVersion) && Objects.equals(this.imageId, other.imageId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.appCatalogListingId == null ? 43 : this.appCatalogListingId.hashCode());
        result = result * 59 + (this.appCatalogListingResourceVersion == null ? 43 : this.appCatalogListingResourceVersion.hashCode());
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="appCatalogListingId")
        private String appCatalogListingId;
        @JsonProperty(value="appCatalogListingResourceVersion")
        private String appCatalogListingResourceVersion;
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder appCatalogListingId(String appCatalogListingId) {
            this.appCatalogListingId = appCatalogListingId;
            this.__explicitlySet__.add("appCatalogListingId");
            return this;
        }

        public Builder appCatalogListingResourceVersion(String appCatalogListingResourceVersion) {
            this.appCatalogListingResourceVersion = appCatalogListingResourceVersion;
            this.__explicitlySet__.add("appCatalogListingResourceVersion");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public ImagePublicationPackage build() {
            ImagePublicationPackage model = new ImagePublicationPackage(this.description, this.listingId, this.version, this.resourceId, this.timeCreated, this.operatingSystem, this.appCatalogListingId, this.appCatalogListingResourceVersion, this.imageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImagePublicationPackage model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("appCatalogListingId")) {
                this.appCatalogListingId(model.getAppCatalogListingId());
            }
            if (model.wasPropertyExplicitlySet("appCatalogListingResourceVersion")) {
                this.appCatalogListingResourceVersion(model.getAppCatalogListingResourceVersion());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            return this;
        }
    }
}

