/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.marketplace.model.CreatePublicationPackage;
import com.oracle.bmc.marketplace.model.ListingType;
import com.oracle.bmc.marketplace.model.SupportContact;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreatePublicationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="listingType")
    private final ListingType listingType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="shortDescription")
    private final String shortDescription;
    @JsonProperty(value="longDescription")
    private final String longDescription;
    @JsonProperty(value="supportContacts")
    private final List<SupportContact> supportContacts;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="packageDetails")
    private final CreatePublicationPackage packageDetails;
    @JsonProperty(value="isAgreementAcknowledged")
    private final Boolean isAgreementAcknowledged;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;

    @Deprecated
    @ConstructorProperties(value={"listingType", "name", "shortDescription", "longDescription", "supportContacts", "compartmentId", "packageDetails", "isAgreementAcknowledged", "definedTags", "freeformTags"})
    public CreatePublicationDetails(ListingType listingType, String name, String shortDescription, String longDescription, List<SupportContact> supportContacts, String compartmentId, CreatePublicationPackage packageDetails, Boolean isAgreementAcknowledged, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags) {
        this.listingType = listingType;
        this.name = name;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.supportContacts = supportContacts;
        this.compartmentId = compartmentId;
        this.packageDetails = packageDetails;
        this.isAgreementAcknowledged = isAgreementAcknowledged;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ListingType getListingType() {
        return this.listingType;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public List<SupportContact> getSupportContacts() {
        return this.supportContacts;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public CreatePublicationPackage getPackageDetails() {
        return this.packageDetails;
    }

    public Boolean getIsAgreementAcknowledged() {
        return this.isAgreementAcknowledged;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreatePublicationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("listingType=").append(String.valueOf((Object)this.listingType));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", shortDescription=").append(String.valueOf(this.shortDescription));
        sb.append(", longDescription=").append(String.valueOf(this.longDescription));
        sb.append(", supportContacts=").append(String.valueOf(this.supportContacts));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", packageDetails=").append(String.valueOf((Object)this.packageDetails));
        sb.append(", isAgreementAcknowledged=").append(String.valueOf(this.isAgreementAcknowledged));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePublicationDetails)) {
            return false;
        }
        CreatePublicationDetails other = (CreatePublicationDetails)((Object)o);
        return Objects.equals((Object)this.listingType, (Object)other.listingType) && Objects.equals(this.name, other.name) && Objects.equals(this.shortDescription, other.shortDescription) && Objects.equals(this.longDescription, other.longDescription) && Objects.equals(this.supportContacts, other.supportContacts) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.packageDetails, (Object)other.packageDetails) && Objects.equals(this.isAgreementAcknowledged, other.isAgreementAcknowledged) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.listingType == null ? 43 : this.listingType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.shortDescription == null ? 43 : this.shortDescription.hashCode());
        result = result * 59 + (this.longDescription == null ? 43 : this.longDescription.hashCode());
        result = result * 59 + (this.supportContacts == null ? 43 : this.supportContacts.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.packageDetails == null ? 43 : this.packageDetails.hashCode());
        result = result * 59 + (this.isAgreementAcknowledged == null ? 43 : this.isAgreementAcknowledged.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="listingType")
        private ListingType listingType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="shortDescription")
        private String shortDescription;
        @JsonProperty(value="longDescription")
        private String longDescription;
        @JsonProperty(value="supportContacts")
        private List<SupportContact> supportContacts;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="packageDetails")
        private CreatePublicationPackage packageDetails;
        @JsonProperty(value="isAgreementAcknowledged")
        private Boolean isAgreementAcknowledged;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder listingType(ListingType listingType) {
            this.listingType = listingType;
            this.__explicitlySet__.add("listingType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            this.__explicitlySet__.add("shortDescription");
            return this;
        }

        public Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            this.__explicitlySet__.add("longDescription");
            return this;
        }

        public Builder supportContacts(List<SupportContact> supportContacts) {
            this.supportContacts = supportContacts;
            this.__explicitlySet__.add("supportContacts");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder packageDetails(CreatePublicationPackage packageDetails) {
            this.packageDetails = packageDetails;
            this.__explicitlySet__.add("packageDetails");
            return this;
        }

        public Builder isAgreementAcknowledged(Boolean isAgreementAcknowledged) {
            this.isAgreementAcknowledged = isAgreementAcknowledged;
            this.__explicitlySet__.add("isAgreementAcknowledged");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public CreatePublicationDetails build() {
            CreatePublicationDetails model = new CreatePublicationDetails(this.listingType, this.name, this.shortDescription, this.longDescription, this.supportContacts, this.compartmentId, this.packageDetails, this.isAgreementAcknowledged, this.definedTags, this.freeformTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreatePublicationDetails model) {
            if (model.wasPropertyExplicitlySet("listingType")) {
                this.listingType(model.getListingType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("shortDescription")) {
                this.shortDescription(model.getShortDescription());
            }
            if (model.wasPropertyExplicitlySet("longDescription")) {
                this.longDescription(model.getLongDescription());
            }
            if (model.wasPropertyExplicitlySet("supportContacts")) {
                this.supportContacts(model.getSupportContacts());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("packageDetails")) {
                this.packageDetails(model.getPackageDetails());
            }
            if (model.wasPropertyExplicitlySet("isAgreementAcknowledged")) {
                this.isAgreementAcknowledged(model.getIsAgreementAcknowledged());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            return this;
        }
    }
}

