/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.marketplace.model.CreatePublicationPackage;
import com.oracle.bmc.marketplace.model.Eula;
import com.oracle.bmc.marketplace.model.OperatingSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateImagePublicationPackage
extends CreatePublicationPackage {
    @JsonProperty(value="imageId")
    private final String imageId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateImagePublicationPackage(String packageVersion, OperatingSystem operatingSystem, List<Eula> eula, String imageId) {
        super(packageVersion, operatingSystem, eula);
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateImagePublicationPackage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateImagePublicationPackage)) {
            return false;
        }
        CreateImagePublicationPackage other = (CreateImagePublicationPackage)((Object)o);
        return Objects.equals(this.imageId, other.imageId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="packageVersion")
        private String packageVersion;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="eula")
        private List<Eula> eula;
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            this.__explicitlySet__.add("packageVersion");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder eula(List<Eula> eula) {
            this.eula = eula;
            this.__explicitlySet__.add("eula");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public CreateImagePublicationPackage build() {
            CreateImagePublicationPackage model = new CreateImagePublicationPackage(this.packageVersion, this.operatingSystem, this.eula, this.imageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateImagePublicationPackage model) {
            if (model.wasPropertyExplicitlySet("packageVersion")) {
                this.packageVersion(model.getPackageVersion());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("eula")) {
                this.eula(model.getEula());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            return this;
        }
    }
}

