/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum ArchitectureType implements BmcEnum
{
    X86("X86"),
    Arm("ARM");

    private final String value;
    private static Map<String, ArchitectureType> map;

    private ArchitectureType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ArchitectureType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid ArchitectureType: " + key);
    }

    static {
        map = new HashMap<String, ArchitectureType>();
        for (ArchitectureType v : ArchitectureType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

