/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Agreement
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="contentUrl")
    private final String contentUrl;
    @JsonProperty(value="signature")
    private final String signature;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="author")
    private final Author author;
    @JsonProperty(value="prompt")
    private final String prompt;

    @Deprecated
    @ConstructorProperties(value={"id", "contentUrl", "signature", "compartmentId", "author", "prompt"})
    public Agreement(String id, String contentUrl, String signature, String compartmentId, Author author, String prompt) {
        this.id = id;
        this.contentUrl = contentUrl;
        this.signature = signature;
        this.compartmentId = compartmentId;
        this.author = author;
        this.prompt = prompt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Author getAuthor() {
        return this.author;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Agreement(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", contentUrl=").append(String.valueOf(this.contentUrl));
        sb.append(", signature=").append(String.valueOf(this.signature));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", author=").append(String.valueOf((Object)this.author));
        sb.append(", prompt=").append(String.valueOf(this.prompt));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Agreement)) {
            return false;
        }
        Agreement other = (Agreement)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.contentUrl, other.contentUrl) && Objects.equals(this.signature, other.signature) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.author, (Object)other.author) && Objects.equals(this.prompt, other.prompt) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.contentUrl == null ? 43 : this.contentUrl.hashCode());
        result = result * 59 + (this.signature == null ? 43 : this.signature.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.author == null ? 43 : this.author.hashCode());
        result = result * 59 + (this.prompt == null ? 43 : this.prompt.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Author implements BmcEnum
    {
        Oracle("ORACLE"),
        Partner("PARTNER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Author> map;

        private Author(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Author create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Author', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Author.class);
            map = new HashMap<String, Author>();
            for (Author v : Author.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="contentUrl")
        private String contentUrl;
        @JsonProperty(value="signature")
        private String signature;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="author")
        private Author author;
        @JsonProperty(value="prompt")
        private String prompt;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.__explicitlySet__.add("contentUrl");
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            this.__explicitlySet__.add("signature");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder author(Author author) {
            this.author = author;
            this.__explicitlySet__.add("author");
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            this.__explicitlySet__.add("prompt");
            return this;
        }

        public Agreement build() {
            Agreement model = new Agreement(this.id, this.contentUrl, this.signature, this.compartmentId, this.author, this.prompt);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Agreement model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("contentUrl")) {
                this.contentUrl(model.getContentUrl());
            }
            if (model.wasPropertyExplicitlySet("signature")) {
                this.signature(model.getSignature());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("author")) {
                this.author(model.getAuthor());
            }
            if (model.wasPropertyExplicitlySet("prompt")) {
                this.prompt(model.getPrompt());
            }
            return this;
        }
    }
}

