/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.oracle.bmc.marketplace.Marketplace;
import com.oracle.bmc.marketplace.model.AcceptedAgreementSummary;
import com.oracle.bmc.marketplace.model.AgreementSummary;
import com.oracle.bmc.marketplace.model.CategorySummary;
import com.oracle.bmc.marketplace.model.ListingPackageSummary;
import com.oracle.bmc.marketplace.model.ListingSummary;
import com.oracle.bmc.marketplace.model.PublicationPackageSummary;
import com.oracle.bmc.marketplace.model.PublicationSummary;
import com.oracle.bmc.marketplace.model.PublisherSummary;
import com.oracle.bmc.marketplace.model.ReportSummary;
import com.oracle.bmc.marketplace.model.ReportTypeSummary;
import com.oracle.bmc.marketplace.requests.ListAcceptedAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListCategoriesRequest;
import com.oracle.bmc.marketplace.requests.ListListingsRequest;
import com.oracle.bmc.marketplace.requests.ListPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationsRequest;
import com.oracle.bmc.marketplace.requests.ListPublishersRequest;
import com.oracle.bmc.marketplace.requests.ListReportTypesRequest;
import com.oracle.bmc.marketplace.requests.ListReportsRequest;
import com.oracle.bmc.marketplace.requests.SearchListingsRequest;
import com.oracle.bmc.marketplace.responses.ListAcceptedAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListCategoriesResponse;
import com.oracle.bmc.marketplace.responses.ListListingsResponse;
import com.oracle.bmc.marketplace.responses.ListPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationsResponse;
import com.oracle.bmc.marketplace.responses.ListPublishersResponse;
import com.oracle.bmc.marketplace.responses.ListReportTypesResponse;
import com.oracle.bmc.marketplace.responses.ListReportsResponse;
import com.oracle.bmc.marketplace.responses.SearchListingsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class MarketplacePaginators {
    private final Marketplace client;

    public MarketplacePaginators(Marketplace client) {
        this.client = client;
    }

    public Iterable<ListAcceptedAgreementsResponse> listAcceptedAgreementsResponseIterator(final ListAcceptedAgreementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAcceptedAgreementsRequest.Builder>(){

            @Override
            public ListAcceptedAgreementsRequest.Builder get() {
                return ListAcceptedAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAcceptedAgreementsResponse, String>(){

            @Override
            public String apply(ListAcceptedAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder>, ListAcceptedAgreementsRequest>(){

            @Override
            public ListAcceptedAgreementsRequest apply(RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse>(){

            @Override
            public ListAcceptedAgreementsResponse apply(ListAcceptedAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAcceptedAgreements(request);
            }
        });
    }

    public Iterable<AcceptedAgreementSummary> listAcceptedAgreementsRecordIterator(final ListAcceptedAgreementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAcceptedAgreementsRequest.Builder>(){

            @Override
            public ListAcceptedAgreementsRequest.Builder get() {
                return ListAcceptedAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAcceptedAgreementsResponse, String>(){

            @Override
            public String apply(ListAcceptedAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder>, ListAcceptedAgreementsRequest>(){

            @Override
            public ListAcceptedAgreementsRequest apply(RequestBuilderAndToken<ListAcceptedAgreementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAcceptedAgreementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse>(){

            @Override
            public ListAcceptedAgreementsResponse apply(ListAcceptedAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAcceptedAgreements(request);
            }
        }, (Function)new Function<ListAcceptedAgreementsResponse, List<AcceptedAgreementSummary>>(){

            @Override
            public List<AcceptedAgreementSummary> apply(ListAcceptedAgreementsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAgreementsResponse> listAgreementsResponseIterator(final ListAgreementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgreementsRequest.Builder>(){

            @Override
            public ListAgreementsRequest.Builder get() {
                return ListAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgreementsResponse, String>(){

            @Override
            public String apply(ListAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgreementsRequest.Builder>, ListAgreementsRequest>(){

            @Override
            public ListAgreementsRequest apply(RequestBuilderAndToken<ListAgreementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgreementsRequest, ListAgreementsResponse>(){

            @Override
            public ListAgreementsResponse apply(ListAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAgreements(request);
            }
        });
    }

    public Iterable<AgreementSummary> listAgreementsRecordIterator(final ListAgreementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgreementsRequest.Builder>(){

            @Override
            public ListAgreementsRequest.Builder get() {
                return ListAgreementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgreementsResponse, String>(){

            @Override
            public String apply(ListAgreementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgreementsRequest.Builder>, ListAgreementsRequest>(){

            @Override
            public ListAgreementsRequest apply(RequestBuilderAndToken<ListAgreementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgreementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgreementsRequest, ListAgreementsResponse>(){

            @Override
            public ListAgreementsResponse apply(ListAgreementsRequest request) {
                return MarketplacePaginators.this.client.listAgreements(request);
            }
        }, (Function)new Function<ListAgreementsResponse, List<AgreementSummary>>(){

            @Override
            public List<AgreementSummary> apply(ListAgreementsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCategoriesResponse> listCategoriesResponseIterator(final ListCategoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            @Override
            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            @Override
            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            @Override
            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            @Override
            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return MarketplacePaginators.this.client.listCategories(request);
            }
        });
    }

    public Iterable<CategorySummary> listCategoriesRecordIterator(final ListCategoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            @Override
            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            @Override
            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            @Override
            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            @Override
            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return MarketplacePaginators.this.client.listCategories(request);
            }
        }, (Function)new Function<ListCategoriesResponse, List<CategorySummary>>(){

            @Override
            public List<CategorySummary> apply(ListCategoriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListListingsResponse> listListingsResponseIterator(final ListListingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListListingsRequest.Builder>(){

            @Override
            public ListListingsRequest.Builder get() {
                return ListListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListListingsResponse, String>(){

            @Override
            public String apply(ListListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListListingsRequest.Builder>, ListListingsRequest>(){

            @Override
            public ListListingsRequest apply(RequestBuilderAndToken<ListListingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListListingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListListingsRequest, ListListingsResponse>(){

            @Override
            public ListListingsResponse apply(ListListingsRequest request) {
                return MarketplacePaginators.this.client.listListings(request);
            }
        });
    }

    public Iterable<ListingSummary> listListingsRecordIterator(final ListListingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListListingsRequest.Builder>(){

            @Override
            public ListListingsRequest.Builder get() {
                return ListListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListListingsResponse, String>(){

            @Override
            public String apply(ListListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListListingsRequest.Builder>, ListListingsRequest>(){

            @Override
            public ListListingsRequest apply(RequestBuilderAndToken<ListListingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListListingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListListingsRequest, ListListingsResponse>(){

            @Override
            public ListListingsResponse apply(ListListingsRequest request) {
                return MarketplacePaginators.this.client.listListings(request);
            }
        }, (Function)new Function<ListListingsResponse, List<ListingSummary>>(){

            @Override
            public List<ListingSummary> apply(ListListingsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPackagesResponse> listPackagesResponseIterator(final ListPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPackagesRequest.Builder>(){

            @Override
            public ListPackagesRequest.Builder get() {
                return ListPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPackagesResponse, String>(){

            @Override
            public String apply(ListPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPackagesRequest.Builder>, ListPackagesRequest>(){

            @Override
            public ListPackagesRequest apply(RequestBuilderAndToken<ListPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPackagesRequest, ListPackagesResponse>(){

            @Override
            public ListPackagesResponse apply(ListPackagesRequest request) {
                return MarketplacePaginators.this.client.listPackages(request);
            }
        });
    }

    public Iterable<ListingPackageSummary> listPackagesRecordIterator(final ListPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPackagesRequest.Builder>(){

            @Override
            public ListPackagesRequest.Builder get() {
                return ListPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPackagesResponse, String>(){

            @Override
            public String apply(ListPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPackagesRequest.Builder>, ListPackagesRequest>(){

            @Override
            public ListPackagesRequest apply(RequestBuilderAndToken<ListPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPackagesRequest, ListPackagesResponse>(){

            @Override
            public ListPackagesResponse apply(ListPackagesRequest request) {
                return MarketplacePaginators.this.client.listPackages(request);
            }
        }, (Function)new Function<ListPackagesResponse, List<ListingPackageSummary>>(){

            @Override
            public List<ListingPackageSummary> apply(ListPackagesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublicationPackagesResponse> listPublicationPackagesResponseIterator(final ListPublicationPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublicationPackagesRequest.Builder>(){

            @Override
            public ListPublicationPackagesRequest.Builder get() {
                return ListPublicationPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationPackagesResponse, String>(){

            @Override
            public String apply(ListPublicationPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationPackagesRequest.Builder>, ListPublicationPackagesRequest>(){

            @Override
            public ListPublicationPackagesRequest apply(RequestBuilderAndToken<ListPublicationPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPublicationPackagesRequest, ListPublicationPackagesResponse>(){

            @Override
            public ListPublicationPackagesResponse apply(ListPublicationPackagesRequest request) {
                return MarketplacePaginators.this.client.listPublicationPackages(request);
            }
        });
    }

    public Iterable<PublicationPackageSummary> listPublicationPackagesRecordIterator(final ListPublicationPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublicationPackagesRequest.Builder>(){

            @Override
            public ListPublicationPackagesRequest.Builder get() {
                return ListPublicationPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationPackagesResponse, String>(){

            @Override
            public String apply(ListPublicationPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationPackagesRequest.Builder>, ListPublicationPackagesRequest>(){

            @Override
            public ListPublicationPackagesRequest apply(RequestBuilderAndToken<ListPublicationPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPublicationPackagesRequest, ListPublicationPackagesResponse>(){

            @Override
            public ListPublicationPackagesResponse apply(ListPublicationPackagesRequest request) {
                return MarketplacePaginators.this.client.listPublicationPackages(request);
            }
        }, (Function)new Function<ListPublicationPackagesResponse, List<PublicationPackageSummary>>(){

            @Override
            public List<PublicationPackageSummary> apply(ListPublicationPackagesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublicationsResponse> listPublicationsResponseIterator(final ListPublicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublicationsRequest.Builder>(){

            @Override
            public ListPublicationsRequest.Builder get() {
                return ListPublicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationsResponse, String>(){

            @Override
            public String apply(ListPublicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationsRequest.Builder>, ListPublicationsRequest>(){

            @Override
            public ListPublicationsRequest apply(RequestBuilderAndToken<ListPublicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPublicationsRequest, ListPublicationsResponse>(){

            @Override
            public ListPublicationsResponse apply(ListPublicationsRequest request) {
                return MarketplacePaginators.this.client.listPublications(request);
            }
        });
    }

    public Iterable<PublicationSummary> listPublicationsRecordIterator(final ListPublicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublicationsRequest.Builder>(){

            @Override
            public ListPublicationsRequest.Builder get() {
                return ListPublicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicationsResponse, String>(){

            @Override
            public String apply(ListPublicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicationsRequest.Builder>, ListPublicationsRequest>(){

            @Override
            public ListPublicationsRequest apply(RequestBuilderAndToken<ListPublicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPublicationsRequest, ListPublicationsResponse>(){

            @Override
            public ListPublicationsResponse apply(ListPublicationsRequest request) {
                return MarketplacePaginators.this.client.listPublications(request);
            }
        }, (Function)new Function<ListPublicationsResponse, List<PublicationSummary>>(){

            @Override
            public List<PublicationSummary> apply(ListPublicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublishersResponse> listPublishersResponseIterator(final ListPublishersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublishersRequest.Builder>(){

            @Override
            public ListPublishersRequest.Builder get() {
                return ListPublishersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublishersResponse, String>(){

            @Override
            public String apply(ListPublishersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublishersRequest.Builder>, ListPublishersRequest>(){

            @Override
            public ListPublishersRequest apply(RequestBuilderAndToken<ListPublishersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPublishersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublishersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPublishersRequest, ListPublishersResponse>(){

            @Override
            public ListPublishersResponse apply(ListPublishersRequest request) {
                return MarketplacePaginators.this.client.listPublishers(request);
            }
        });
    }

    public Iterable<PublisherSummary> listPublishersRecordIterator(final ListPublishersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublishersRequest.Builder>(){

            @Override
            public ListPublishersRequest.Builder get() {
                return ListPublishersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublishersResponse, String>(){

            @Override
            public String apply(ListPublishersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublishersRequest.Builder>, ListPublishersRequest>(){

            @Override
            public ListPublishersRequest apply(RequestBuilderAndToken<ListPublishersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPublishersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublishersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPublishersRequest, ListPublishersResponse>(){

            @Override
            public ListPublishersResponse apply(ListPublishersRequest request) {
                return MarketplacePaginators.this.client.listPublishers(request);
            }
        }, (Function)new Function<ListPublishersResponse, List<PublisherSummary>>(){

            @Override
            public List<PublisherSummary> apply(ListPublishersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReportTypesResponse> listReportTypesResponseIterator(final ListReportTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReportTypesRequest.Builder>(){

            @Override
            public ListReportTypesRequest.Builder get() {
                return ListReportTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportTypesResponse, String>(){

            @Override
            public String apply(ListReportTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportTypesRequest.Builder>, ListReportTypesRequest>(){

            @Override
            public ListReportTypesRequest apply(RequestBuilderAndToken<ListReportTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReportTypesRequest, ListReportTypesResponse>(){

            @Override
            public ListReportTypesResponse apply(ListReportTypesRequest request) {
                return MarketplacePaginators.this.client.listReportTypes(request);
            }
        });
    }

    public Iterable<ReportTypeSummary> listReportTypesRecordIterator(final ListReportTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReportTypesRequest.Builder>(){

            @Override
            public ListReportTypesRequest.Builder get() {
                return ListReportTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportTypesResponse, String>(){

            @Override
            public String apply(ListReportTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportTypesRequest.Builder>, ListReportTypesRequest>(){

            @Override
            public ListReportTypesRequest apply(RequestBuilderAndToken<ListReportTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReportTypesRequest, ListReportTypesResponse>(){

            @Override
            public ListReportTypesResponse apply(ListReportTypesRequest request) {
                return MarketplacePaginators.this.client.listReportTypes(request);
            }
        }, (Function)new Function<ListReportTypesResponse, List<ReportTypeSummary>>(){

            @Override
            public List<ReportTypeSummary> apply(ListReportTypesResponse response) {
                return response.getReportTypeCollection().getItems();
            }
        });
    }

    public Iterable<ListReportsResponse> listReportsResponseIterator(final ListReportsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReportsRequest.Builder>(){

            @Override
            public ListReportsRequest.Builder get() {
                return ListReportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportsResponse, String>(){

            @Override
            public String apply(ListReportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportsRequest.Builder>, ListReportsRequest>(){

            @Override
            public ListReportsRequest apply(RequestBuilderAndToken<ListReportsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReportsRequest, ListReportsResponse>(){

            @Override
            public ListReportsResponse apply(ListReportsRequest request) {
                return MarketplacePaginators.this.client.listReports(request);
            }
        });
    }

    public Iterable<ReportSummary> listReportsRecordIterator(final ListReportsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReportsRequest.Builder>(){

            @Override
            public ListReportsRequest.Builder get() {
                return ListReportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReportsResponse, String>(){

            @Override
            public String apply(ListReportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReportsRequest.Builder>, ListReportsRequest>(){

            @Override
            public ListReportsRequest apply(RequestBuilderAndToken<ListReportsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReportsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReportsRequest, ListReportsResponse>(){

            @Override
            public ListReportsResponse apply(ListReportsRequest request) {
                return MarketplacePaginators.this.client.listReports(request);
            }
        }, (Function)new Function<ListReportsResponse, List<ReportSummary>>(){

            @Override
            public List<ReportSummary> apply(ListReportsResponse response) {
                return response.getReportCollection().getItems();
            }
        });
    }

    public Iterable<SearchListingsResponse> searchListingsResponseIterator(final SearchListingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<SearchListingsRequest.Builder>(){

            @Override
            public SearchListingsRequest.Builder get() {
                return SearchListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<SearchListingsResponse, String>(){

            @Override
            public String apply(SearchListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<SearchListingsRequest.Builder>, SearchListingsRequest>(){

            @Override
            public SearchListingsRequest apply(RequestBuilderAndToken<SearchListingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((SearchListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((SearchListingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<SearchListingsRequest, SearchListingsResponse>(){

            @Override
            public SearchListingsResponse apply(SearchListingsRequest request) {
                return MarketplacePaginators.this.client.searchListings(request);
            }
        });
    }

    public Iterable<ListingSummary> searchListingsRecordIterator(final SearchListingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<SearchListingsRequest.Builder>(){

            @Override
            public SearchListingsRequest.Builder get() {
                return SearchListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<SearchListingsResponse, String>(){

            @Override
            public String apply(SearchListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<SearchListingsRequest.Builder>, SearchListingsRequest>(){

            @Override
            public SearchListingsRequest apply(RequestBuilderAndToken<SearchListingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((SearchListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((SearchListingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<SearchListingsRequest, SearchListingsResponse>(){

            @Override
            public SearchListingsResponse apply(SearchListingsRequest request) {
                return MarketplacePaginators.this.client.searchListings(request);
            }
        }, (Function)new Function<SearchListingsResponse, List<ListingSummary>>(){

            @Override
            public List<ListingSummary> apply(SearchListingsResponse response) {
                return response.getItems();
            }
        });
    }
}

