/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.marketplace.MarketplaceAsync;
import com.oracle.bmc.marketplace.model.AcceptedAgreement;
import com.oracle.bmc.marketplace.model.AcceptedAgreementSummary;
import com.oracle.bmc.marketplace.model.Agreement;
import com.oracle.bmc.marketplace.model.AgreementSummary;
import com.oracle.bmc.marketplace.model.CategorySummary;
import com.oracle.bmc.marketplace.model.Listing;
import com.oracle.bmc.marketplace.model.ListingPackage;
import com.oracle.bmc.marketplace.model.ListingPackageSummary;
import com.oracle.bmc.marketplace.model.ListingSummary;
import com.oracle.bmc.marketplace.model.Publication;
import com.oracle.bmc.marketplace.model.PublicationPackage;
import com.oracle.bmc.marketplace.model.PublicationPackageSummary;
import com.oracle.bmc.marketplace.model.PublicationSummary;
import com.oracle.bmc.marketplace.model.PublisherSummary;
import com.oracle.bmc.marketplace.model.ReportCollection;
import com.oracle.bmc.marketplace.model.ReportTypeCollection;
import com.oracle.bmc.marketplace.model.TaxSummary;
import com.oracle.bmc.marketplace.requests.ChangePublicationCompartmentRequest;
import com.oracle.bmc.marketplace.requests.CreateAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.CreatePublicationRequest;
import com.oracle.bmc.marketplace.requests.DeleteAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.DeletePublicationRequest;
import com.oracle.bmc.marketplace.requests.GetAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.GetAgreementRequest;
import com.oracle.bmc.marketplace.requests.GetListingRequest;
import com.oracle.bmc.marketplace.requests.GetPackageRequest;
import com.oracle.bmc.marketplace.requests.GetPublicationPackageRequest;
import com.oracle.bmc.marketplace.requests.GetPublicationRequest;
import com.oracle.bmc.marketplace.requests.ListAcceptedAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListAgreementsRequest;
import com.oracle.bmc.marketplace.requests.ListCategoriesRequest;
import com.oracle.bmc.marketplace.requests.ListListingsRequest;
import com.oracle.bmc.marketplace.requests.ListPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationPackagesRequest;
import com.oracle.bmc.marketplace.requests.ListPublicationsRequest;
import com.oracle.bmc.marketplace.requests.ListPublishersRequest;
import com.oracle.bmc.marketplace.requests.ListReportTypesRequest;
import com.oracle.bmc.marketplace.requests.ListReportsRequest;
import com.oracle.bmc.marketplace.requests.ListTaxesRequest;
import com.oracle.bmc.marketplace.requests.SearchListingsRequest;
import com.oracle.bmc.marketplace.requests.UpdateAcceptedAgreementRequest;
import com.oracle.bmc.marketplace.requests.UpdatePublicationRequest;
import com.oracle.bmc.marketplace.responses.ChangePublicationCompartmentResponse;
import com.oracle.bmc.marketplace.responses.CreateAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.CreatePublicationResponse;
import com.oracle.bmc.marketplace.responses.DeleteAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.DeletePublicationResponse;
import com.oracle.bmc.marketplace.responses.GetAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.GetAgreementResponse;
import com.oracle.bmc.marketplace.responses.GetListingResponse;
import com.oracle.bmc.marketplace.responses.GetPackageResponse;
import com.oracle.bmc.marketplace.responses.GetPublicationPackageResponse;
import com.oracle.bmc.marketplace.responses.GetPublicationResponse;
import com.oracle.bmc.marketplace.responses.ListAcceptedAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListAgreementsResponse;
import com.oracle.bmc.marketplace.responses.ListCategoriesResponse;
import com.oracle.bmc.marketplace.responses.ListListingsResponse;
import com.oracle.bmc.marketplace.responses.ListPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationPackagesResponse;
import com.oracle.bmc.marketplace.responses.ListPublicationsResponse;
import com.oracle.bmc.marketplace.responses.ListPublishersResponse;
import com.oracle.bmc.marketplace.responses.ListReportTypesResponse;
import com.oracle.bmc.marketplace.responses.ListReportsResponse;
import com.oracle.bmc.marketplace.responses.ListTaxesResponse;
import com.oracle.bmc.marketplace.responses.SearchListingsResponse;
import com.oracle.bmc.marketplace.responses.UpdateAcceptedAgreementResponse;
import com.oracle.bmc.marketplace.responses.UpdatePublicationResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceAsyncClient
extends BaseAsyncClient
implements MarketplaceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MARKETPLACE").serviceEndpointPrefix("").serviceEndpointTemplate("https://marketplace.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(MarketplaceAsyncClient.class);

    private MarketplaceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangePublicationCompartmentResponse> changePublicationCompartment(ChangePublicationCompartmentRequest request, AsyncHandler<ChangePublicationCompartmentRequest, ChangePublicationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getPublicationId(), (String)"publicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePublicationCompartmentDetails(), "changePublicationCompartmentDetails is required");
        return this.clientCall(request, ChangePublicationCompartmentResponse::builder).logger(LOG, "changePublicationCompartment").serviceDetails("Marketplace", "ChangePublicationCompartment", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Publication/ChangePublicationCompartment").method(Method.POST).requestBuilder(ChangePublicationCompartmentRequest::builder).basePath("/20181001").appendPathParam("publications").appendPathParam(request.getPublicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangePublicationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAcceptedAgreementResponse> createAcceptedAgreement(CreateAcceptedAgreementRequest request, AsyncHandler<CreateAcceptedAgreementRequest, CreateAcceptedAgreementResponse> handler) {
        Objects.requireNonNull(request.getCreateAcceptedAgreementDetails(), "createAcceptedAgreementDetails is required");
        return this.clientCall(request, CreateAcceptedAgreementResponse::builder).logger(LOG, "createAcceptedAgreement").serviceDetails("Marketplace", "CreateAcceptedAgreement", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/AcceptedAgreement/CreateAcceptedAgreement").method(Method.POST).requestBuilder(CreateAcceptedAgreementRequest::builder).basePath("/20181001").appendPathParam("acceptedAgreements").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AcceptedAgreement.class, CreateAcceptedAgreementResponse.Builder::acceptedAgreement).handleResponseHeaderString("opc-request-id", CreateAcceptedAgreementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAcceptedAgreementResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreatePublicationResponse> createPublication(CreatePublicationRequest request, AsyncHandler<CreatePublicationRequest, CreatePublicationResponse> handler) {
        Objects.requireNonNull(request.getCreatePublicationDetails(), "createPublicationDetails is required");
        return this.clientCall(request, CreatePublicationResponse::builder).logger(LOG, "createPublication").serviceDetails("Marketplace", "CreatePublication", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Publication/CreatePublication").method(Method.POST).requestBuilder(CreatePublicationRequest::builder).basePath("/20181001").appendPathParam("publications").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Publication.class, CreatePublicationResponse.Builder::publication).handleResponseHeaderString("opc-request-id", CreatePublicationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePublicationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteAcceptedAgreementResponse> deleteAcceptedAgreement(DeleteAcceptedAgreementRequest request, AsyncHandler<DeleteAcceptedAgreementRequest, DeleteAcceptedAgreementResponse> handler) {
        Validate.notBlank((String)request.getAcceptedAgreementId(), (String)"acceptedAgreementId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAcceptedAgreementResponse::builder).logger(LOG, "deleteAcceptedAgreement").serviceDetails("Marketplace", "DeleteAcceptedAgreement", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/AcceptedAgreement/DeleteAcceptedAgreement").method(Method.DELETE).requestBuilder(DeleteAcceptedAgreementRequest::builder).basePath("/20181001").appendPathParam("acceptedAgreements").appendPathParam(request.getAcceptedAgreementId()).appendQueryParam("signature", (Object)request.getSignature()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteAcceptedAgreementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePublicationResponse> deletePublication(DeletePublicationRequest request, AsyncHandler<DeletePublicationRequest, DeletePublicationResponse> handler) {
        Validate.notBlank((String)request.getPublicationId(), (String)"publicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePublicationResponse::builder).logger(LOG, "deletePublication").serviceDetails("Marketplace", "DeletePublication", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Publication/DeletePublication").method(Method.DELETE).requestBuilder(DeletePublicationRequest::builder).basePath("/20181001").appendPathParam("publications").appendPathParam(request.getPublicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAcceptedAgreementResponse> getAcceptedAgreement(GetAcceptedAgreementRequest request, AsyncHandler<GetAcceptedAgreementRequest, GetAcceptedAgreementResponse> handler) {
        Validate.notBlank((String)request.getAcceptedAgreementId(), (String)"acceptedAgreementId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAcceptedAgreementResponse::builder).logger(LOG, "getAcceptedAgreement").serviceDetails("Marketplace", "GetAcceptedAgreement", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/AcceptedAgreement/GetAcceptedAgreement").method(Method.GET).requestBuilder(GetAcceptedAgreementRequest::builder).basePath("/20181001").appendPathParam("acceptedAgreements").appendPathParam(request.getAcceptedAgreementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AcceptedAgreement.class, GetAcceptedAgreementResponse.Builder::acceptedAgreement).handleResponseHeaderString("opc-request-id", GetAcceptedAgreementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAcceptedAgreementResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetAgreementResponse> getAgreement(GetAgreementRequest request, AsyncHandler<GetAgreementRequest, GetAgreementResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageVersion(), (String)"packageVersion must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAgreementId(), (String)"agreementId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAgreementResponse::builder).logger(LOG, "getAgreement").serviceDetails("Marketplace", "GetAgreement", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Agreement/GetAgreement").method(Method.GET).requestBuilder(GetAgreementRequest::builder).basePath("/20181001").appendPathParam("listings").appendPathParam(request.getListingId()).appendPathParam("packages").appendPathParam(request.getPackageVersion()).appendPathParam("agreements").appendPathParam(request.getAgreementId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Agreement.class, GetAgreementResponse.Builder::agreement).handleResponseHeaderString("opc-request-id", GetAgreementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetListingResponse> getListing(GetListingRequest request, AsyncHandler<GetListingRequest, GetListingResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetListingResponse::builder).logger(LOG, "getListing").serviceDetails("Marketplace", "GetListing", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Listing/GetListing").method(Method.GET).requestBuilder(GetListingRequest::builder).basePath("/20181001").appendPathParam("listings").appendPathParam(request.getListingId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Listing.class, GetListingResponse.Builder::listing).handleResponseHeaderString("opc-request-id", GetListingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetListingResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetPackageResponse> getPackage(GetPackageRequest request, AsyncHandler<GetPackageRequest, GetPackageResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageVersion(), (String)"packageVersion must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPackageResponse::builder).logger(LOG, "getPackage").serviceDetails("Marketplace", "GetPackage", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ListingPackage/GetPackage").method(Method.GET).requestBuilder(GetPackageRequest::builder).basePath("/20181001").appendPathParam("listings").appendPathParam(request.getListingId()).appendPathParam("packages").appendPathParam(request.getPackageVersion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ListingPackage.class, GetPackageResponse.Builder::listingPackage).handleResponseHeaderString("opc-request-id", GetPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPackageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetPublicationResponse> getPublication(GetPublicationRequest request, AsyncHandler<GetPublicationRequest, GetPublicationResponse> handler) {
        Validate.notBlank((String)request.getPublicationId(), (String)"publicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPublicationResponse::builder).logger(LOG, "getPublication").serviceDetails("Marketplace", "GetPublication", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Publication/GetPublication").method(Method.GET).requestBuilder(GetPublicationRequest::builder).basePath("/20181001").appendPathParam("publications").appendPathParam(request.getPublicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Publication.class, GetPublicationResponse.Builder::publication).handleResponseHeaderString("etag", GetPublicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPublicationPackageResponse> getPublicationPackage(GetPublicationPackageRequest request, AsyncHandler<GetPublicationPackageRequest, GetPublicationPackageResponse> handler) {
        Validate.notBlank((String)request.getPublicationId(), (String)"publicationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageVersion(), (String)"packageVersion must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPublicationPackageResponse::builder).logger(LOG, "getPublicationPackage").serviceDetails("Marketplace", "GetPublicationPackage", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/PublicationPackage/GetPublicationPackage").method(Method.GET).requestBuilder(GetPublicationPackageRequest::builder).basePath("/20181001").appendPathParam("publications").appendPathParam(request.getPublicationId()).appendPathParam("packages").appendPathParam(request.getPackageVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PublicationPackage.class, GetPublicationPackageResponse.Builder::publicationPackage).handleResponseHeaderString("etag", GetPublicationPackageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPublicationPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAcceptedAgreementsResponse> listAcceptedAgreements(ListAcceptedAgreementsRequest request, AsyncHandler<ListAcceptedAgreementsRequest, ListAcceptedAgreementsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAcceptedAgreementsResponse::builder).logger(LOG, "listAcceptedAgreements").serviceDetails("Marketplace", "ListAcceptedAgreements", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/AcceptedAgreementSummary/ListAcceptedAgreements").method(Method.GET).requestBuilder(ListAcceptedAgreementsRequest::builder).basePath("/20181001").appendPathParam("acceptedAgreements").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("listingId", (Object)request.getListingId()).appendQueryParam("packageVersion", (Object)request.getPackageVersion()).appendQueryParam("acceptedAgreementId", (Object)request.getAcceptedAgreementId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AcceptedAgreementSummary.class, ListAcceptedAgreementsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAcceptedAgreementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAcceptedAgreementsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAgreementsResponse> listAgreements(ListAgreementsRequest request, AsyncHandler<ListAgreementsRequest, ListAgreementsResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageVersion(), (String)"packageVersion must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAgreementsResponse::builder).logger(LOG, "listAgreements").serviceDetails("Marketplace", "ListAgreements", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/AgreementSummary/ListAgreements").method(Method.GET).requestBuilder(ListAgreementsRequest::builder).basePath("/20181001").appendPathParam("listings").appendPathParam(request.getListingId()).appendPathParam("packages").appendPathParam(request.getPackageVersion()).appendPathParam("agreements").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AgreementSummary.class, ListAgreementsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAgreementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgreementsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCategoriesResponse> listCategories(ListCategoriesRequest request, AsyncHandler<ListCategoriesRequest, ListCategoriesResponse> handler) {
        return this.clientCall(request, ListCategoriesResponse::builder).logger(LOG, "listCategories").serviceDetails("Marketplace", "ListCategories", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/CategorySummary/ListCategories").method(Method.GET).requestBuilder(ListCategoriesRequest::builder).basePath("/20181001").appendPathParam("categories").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CategorySummary.class, ListCategoriesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCategoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCategoriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListListingsResponse> listListings(ListListingsRequest request, AsyncHandler<ListListingsRequest, ListListingsResponse> handler) {
        return this.clientCall(request, ListListingsResponse::builder).logger(LOG, "listListings").serviceDetails("Marketplace", "ListListings", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ListingSummary/ListListings").method(Method.GET).requestBuilder(ListListingsRequest::builder).basePath("/20181001").appendPathParam("listings").appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("listingId", (Object)request.getListingId()).appendQueryParam("imageId", (Object)request.getImageId()).appendQueryParam("publisherId", (Object)request.getPublisherId()).appendQueryParam("packageType", (Object)request.getPackageType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("category", request.getCategory(), CollectionFormatType.Multi).appendListQueryParam("pricing", request.getPricing(), CollectionFormatType.Multi).appendQueryParam("isFeatured", (Object)request.getIsFeatured()).appendListQueryParam("listingTypes", request.getListingTypes(), CollectionFormatType.Multi).appendListQueryParam("operatingSystems", request.getOperatingSystems(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ListingSummary.class, ListListingsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListListingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListListingsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPackagesResponse> listPackages(ListPackagesRequest request, AsyncHandler<ListPackagesRequest, ListPackagesResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPackagesResponse::builder).logger(LOG, "listPackages").serviceDetails("Marketplace", "ListPackages", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ListingPackageSummary/ListPackages").method(Method.GET).requestBuilder(ListPackagesRequest::builder).basePath("/20181001").appendPathParam("listings").appendPathParam(request.getListingId()).appendPathParam("packages").appendQueryParam("packageVersion", (Object)request.getPackageVersion()).appendQueryParam("packageType", (Object)request.getPackageType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ListingPackageSummary.class, ListPackagesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPublicationPackagesResponse> listPublicationPackages(ListPublicationPackagesRequest request, AsyncHandler<ListPublicationPackagesRequest, ListPublicationPackagesResponse> handler) {
        Validate.notBlank((String)request.getPublicationId(), (String)"publicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPublicationPackagesResponse::builder).logger(LOG, "listPublicationPackages").serviceDetails("Marketplace", "ListPublicationPackages", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/PublicationPackageSummary/ListPublicationPackages").method(Method.GET).requestBuilder(ListPublicationPackagesRequest::builder).basePath("/20181001").appendPathParam("publications").appendPathParam(request.getPublicationId()).appendPathParam("packages").appendQueryParam("packageVersion", (Object)request.getPackageVersion()).appendQueryParam("packageType", (Object)request.getPackageType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PublicationPackageSummary.class, ListPublicationPackagesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPublicationPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPublicationPackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPublicationsResponse> listPublications(ListPublicationsRequest request, AsyncHandler<ListPublicationsRequest, ListPublicationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getListingType(), "listingType is required");
        return this.clientCall(request, ListPublicationsResponse::builder).logger(LOG, "listPublications").serviceDetails("Marketplace", "ListPublications", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/PublicationSummary/ListPublications").method(Method.GET).requestBuilder(ListPublicationsRequest::builder).basePath("/20181001").appendPathParam("publications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendEnumQueryParam("listingType", (BmcEnum)request.getListingType()).appendQueryParam("publicationId", (Object)request.getPublicationId()).appendListQueryParam("operatingSystems", request.getOperatingSystems(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PublicationSummary.class, ListPublicationsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPublicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPublicationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPublishersResponse> listPublishers(ListPublishersRequest request, AsyncHandler<ListPublishersRequest, ListPublishersResponse> handler) {
        return this.clientCall(request, ListPublishersResponse::builder).logger(LOG, "listPublishers").serviceDetails("Marketplace", "ListPublishers", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/PublisherSummary/ListPublishers").method(Method.GET).requestBuilder(ListPublishersRequest::builder).basePath("/20181001").appendPathParam("publishers").appendQueryParam("publisherId", (Object)request.getPublisherId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PublisherSummary.class, ListPublishersResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPublishersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPublishersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListReportTypesResponse> listReportTypes(ListReportTypesRequest request, AsyncHandler<ListReportTypesRequest, ListReportTypesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListReportTypesResponse::builder).logger(LOG, "listReportTypes").serviceDetails("Marketplace", "ListReportTypes", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ReportTypeCollection/ListReportTypes").method(Method.GET).requestBuilder(ListReportTypesRequest::builder).basePath("/20181001").appendPathParam("reportTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReportTypeCollection.class, ListReportTypesResponse.Builder::reportTypeCollection).handleResponseHeaderString("opc-request-id", ListReportTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReportTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListReportsResponse> listReports(ListReportsRequest request, AsyncHandler<ListReportsRequest, ListReportsResponse> handler) {
        Objects.requireNonNull(request.getReportType(), "reportType is required");
        Objects.requireNonNull(request.getDate(), "date is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListReportsResponse::builder).logger(LOG, "listReports").serviceDetails("Marketplace", "ListReports", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ReportCollection/ListReports").method(Method.GET).requestBuilder(ListReportsRequest::builder).basePath("/20181001").appendPathParam("reports").appendQueryParam("reportType", (Object)request.getReportType()).appendQueryParam("date", (Object)request.getDate()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReportCollection.class, ListReportsResponse.Builder::reportCollection).handleResponseHeaderString("opc-request-id", ListReportsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReportsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTaxesResponse> listTaxes(ListTaxesRequest request, AsyncHandler<ListTaxesRequest, ListTaxesResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaxesResponse::builder).logger(LOG, "listTaxes").serviceDetails("Marketplace", "ListTaxes", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/TaxSummary/ListTaxes").method(Method.GET).requestBuilder(ListTaxesRequest::builder).basePath("/20181001").appendPathParam("listings").appendPathParam(request.getListingId()).appendPathParam("taxes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TaxSummary.class, ListTaxesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTaxesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaxesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SearchListingsResponse> searchListings(SearchListingsRequest request, AsyncHandler<SearchListingsRequest, SearchListingsResponse> handler) {
        Objects.requireNonNull(request.getSearchListingsDetails(), "searchListingsDetails is required");
        return this.clientCall(request, SearchListingsResponse::builder).logger(LOG, "searchListings").serviceDetails("Marketplace", "SearchListings", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ListingSummary/SearchListings").method(Method.POST).requestBuilder(SearchListingsRequest::builder).basePath("/20181001").appendPathParam("searchListings").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBodyList(ListingSummary.class, SearchListingsResponse.Builder::items).handleResponseHeaderString("opc-request-id", SearchListingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchListingsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateAcceptedAgreementResponse> updateAcceptedAgreement(UpdateAcceptedAgreementRequest request, AsyncHandler<UpdateAcceptedAgreementRequest, UpdateAcceptedAgreementResponse> handler) {
        Validate.notBlank((String)request.getAcceptedAgreementId(), (String)"acceptedAgreementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAcceptedAgreementDetails(), "updateAcceptedAgreementDetails is required");
        return this.clientCall(request, UpdateAcceptedAgreementResponse::builder).logger(LOG, "updateAcceptedAgreement").serviceDetails("Marketplace", "UpdateAcceptedAgreement", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/AcceptedAgreement/UpdateAcceptedAgreement").method(Method.PUT).requestBuilder(UpdateAcceptedAgreementRequest::builder).basePath("/20181001").appendPathParam("acceptedAgreements").appendPathParam(request.getAcceptedAgreementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AcceptedAgreement.class, UpdateAcceptedAgreementResponse.Builder::acceptedAgreement).handleResponseHeaderString("opc-request-id", UpdateAcceptedAgreementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAcceptedAgreementResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdatePublicationResponse> updatePublication(UpdatePublicationRequest request, AsyncHandler<UpdatePublicationRequest, UpdatePublicationResponse> handler) {
        Validate.notBlank((String)request.getPublicationId(), (String)"publicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePublicationDetails(), "updatePublicationDetails is required");
        return this.clientCall(request, UpdatePublicationResponse::builder).logger(LOG, "updatePublication").serviceDetails("Marketplace", "UpdatePublication", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/Publication/UpdatePublication").method(Method.PUT).requestBuilder(UpdatePublicationRequest::builder).basePath("/20181001").appendPathParam("publications").appendPathParam(request.getPublicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Publication.class, UpdatePublicationResponse.Builder::publication).handleResponseHeaderString("etag", UpdatePublicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePublicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public MarketplaceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)MarketplaceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public MarketplaceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(MarketplaceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public MarketplaceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)MarketplaceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)MarketplaceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)MarketplaceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)MarketplaceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public MarketplaceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MarketplaceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MarketplaceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public MarketplaceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new MarketplaceAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

