/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.marketplace.AccountAsync;
import com.oracle.bmc.marketplace.model.LaunchEligibility;
import com.oracle.bmc.marketplace.model.ThirdPartyPaidListingEligibility;
import com.oracle.bmc.marketplace.requests.GetLaunchEligibilityRequest;
import com.oracle.bmc.marketplace.requests.GetThirdPartyPaidListingEligibilityRequest;
import com.oracle.bmc.marketplace.responses.GetLaunchEligibilityResponse;
import com.oracle.bmc.marketplace.responses.GetThirdPartyPaidListingEligibilityResponse;
import com.oracle.bmc.responses.AsyncHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountAsyncClient
extends BaseAsyncClient
implements AccountAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ACCOUNT").serviceEndpointPrefix("").serviceEndpointTemplate("https://marketplace.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AccountAsyncClient.class);

    private AccountAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetLaunchEligibilityResponse> getLaunchEligibility(GetLaunchEligibilityRequest request, AsyncHandler<GetLaunchEligibilityRequest, GetLaunchEligibilityResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getImageId(), "imageId is required");
        return this.clientCall(request, GetLaunchEligibilityResponse::builder).logger(LOG, "getLaunchEligibility").serviceDetails("Account", "GetLaunchEligibility", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/LaunchEligibility/GetLaunchEligibility").method(Method.GET).requestBuilder(GetLaunchEligibilityRequest::builder).basePath("/20181001").appendPathParam("launchEligibility").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("imageId", (Object)request.getImageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LaunchEligibility.class, GetLaunchEligibilityResponse.Builder::launchEligibility).handleResponseHeaderString("opc-request-id", GetLaunchEligibilityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetThirdPartyPaidListingEligibilityResponse> getThirdPartyPaidListingEligibility(GetThirdPartyPaidListingEligibilityRequest request, AsyncHandler<GetThirdPartyPaidListingEligibilityRequest, GetThirdPartyPaidListingEligibilityResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetThirdPartyPaidListingEligibilityResponse::builder).logger(LOG, "getThirdPartyPaidListingEligibility").serviceDetails("Account", "GetThirdPartyPaidListingEligibility", "https://docs.oracle.com/iaas/api/#/en/marketplace/20181001/ThirdPartyPaidListingEligibility/GetThirdPartyPaidListingEligibility").method(Method.GET).requestBuilder(GetThirdPartyPaidListingEligibilityRequest::builder).basePath("/20181001").appendPathParam("thirdPartyPaidListingEligibility").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ThirdPartyPaidListingEligibility.class, GetThirdPartyPaidListingEligibilityResponse.Builder::thirdPartyPaidListingEligibility).handleResponseHeaderString("opc-request-id", GetThirdPartyPaidListingEligibilityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AccountAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AccountAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccountAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AccountAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccountAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AccountAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccountAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AccountAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AccountAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AccountAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AccountAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AccountAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AccountAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AccountAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AccountAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AccountAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AccountAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

