/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLogIncludedSearchRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String logIncludedSearchId;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getLogIncludedSearchId() {
        return this.logIncludedSearchId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).logIncludedSearchId(this.logIncludedSearchId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",logIncludedSearchId=").append(String.valueOf(this.logIncludedSearchId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLogIncludedSearchRequest)) {
            return false;
        }
        GetLogIncludedSearchRequest other = (GetLogIncludedSearchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.logIncludedSearchId, other.logIncludedSearchId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.logIncludedSearchId == null ? 43 : this.logIncludedSearchId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogIncludedSearchRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String logIncludedSearchId = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder logIncludedSearchId(String logIncludedSearchId) {
            this.logIncludedSearchId = logIncludedSearchId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogIncludedSearchRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.logIncludedSearchId(o.getLogIncludedSearchId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogIncludedSearchRequest build() {
            GetLogIncludedSearchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLogIncludedSearchRequest buildWithoutInvocationCallback() {
            GetLogIncludedSearchRequest request = new GetLogIncludedSearchRequest();
            request.compartmentId = this.compartmentId;
            request.logIncludedSearchId = this.logIncludedSearchId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

