/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListLabelsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String labelName;
    private String labelDisplayText;
    private IsSystem isSystem;
    private LabelPriority labelPriority;
    private Boolean isCountPop;
    private Boolean isAliasPop;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private LabelSortBy labelSortBy;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getLabelDisplayText() {
        return this.labelDisplayText;
    }

    public IsSystem getIsSystem() {
        return this.isSystem;
    }

    public LabelPriority getLabelPriority() {
        return this.labelPriority;
    }

    public Boolean getIsCountPop() {
        return this.isCountPop;
    }

    public Boolean getIsAliasPop() {
        return this.isAliasPop;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LabelSortBy getLabelSortBy() {
        return this.labelSortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).labelName(this.labelName).labelDisplayText(this.labelDisplayText).isSystem(this.isSystem).labelPriority(this.labelPriority).isCountPop(this.isCountPop).isAliasPop(this.isAliasPop).limit(this.limit).page(this.page).sortOrder(this.sortOrder).labelSortBy(this.labelSortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",labelName=").append(String.valueOf(this.labelName));
        sb.append(",labelDisplayText=").append(String.valueOf(this.labelDisplayText));
        sb.append(",isSystem=").append(String.valueOf((Object)this.isSystem));
        sb.append(",labelPriority=").append(String.valueOf((Object)this.labelPriority));
        sb.append(",isCountPop=").append(String.valueOf(this.isCountPop));
        sb.append(",isAliasPop=").append(String.valueOf(this.isAliasPop));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",labelSortBy=").append(String.valueOf((Object)this.labelSortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListLabelsRequest)) {
            return false;
        }
        ListLabelsRequest other = (ListLabelsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.labelName, other.labelName) && Objects.equals(this.labelDisplayText, other.labelDisplayText) && Objects.equals((Object)this.isSystem, (Object)other.isSystem) && Objects.equals((Object)this.labelPriority, (Object)other.labelPriority) && Objects.equals(this.isCountPop, other.isCountPop) && Objects.equals(this.isAliasPop, other.isAliasPop) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.labelSortBy, (Object)other.labelSortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.labelName == null ? 43 : this.labelName.hashCode());
        result = result * 59 + (this.labelDisplayText == null ? 43 : this.labelDisplayText.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.labelPriority == null ? 43 : this.labelPriority.hashCode());
        result = result * 59 + (this.isCountPop == null ? 43 : this.isCountPop.hashCode());
        result = result * 59 + (this.isAliasPop == null ? 43 : this.isAliasPop.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.labelSortBy == null ? 43 : this.labelSortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLabelsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String labelName = null;
        private String labelDisplayText = null;
        private IsSystem isSystem = null;
        private LabelPriority labelPriority = null;
        private Boolean isCountPop = null;
        private Boolean isAliasPop = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private LabelSortBy labelSortBy = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder labelName(String labelName) {
            this.labelName = labelName;
            return this;
        }

        public Builder labelDisplayText(String labelDisplayText) {
            this.labelDisplayText = labelDisplayText;
            return this;
        }

        public Builder isSystem(IsSystem isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder labelPriority(LabelPriority labelPriority) {
            this.labelPriority = labelPriority;
            return this;
        }

        public Builder isCountPop(Boolean isCountPop) {
            this.isCountPop = isCountPop;
            return this;
        }

        public Builder isAliasPop(Boolean isAliasPop) {
            this.isAliasPop = isAliasPop;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder labelSortBy(LabelSortBy labelSortBy) {
            this.labelSortBy = labelSortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLabelsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.labelName(o.getLabelName());
            this.labelDisplayText(o.getLabelDisplayText());
            this.isSystem(o.getIsSystem());
            this.labelPriority(o.getLabelPriority());
            this.isCountPop(o.getIsCountPop());
            this.isAliasPop(o.getIsAliasPop());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.labelSortBy(o.getLabelSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLabelsRequest build() {
            ListLabelsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListLabelsRequest buildWithoutInvocationCallback() {
            ListLabelsRequest request = new ListLabelsRequest();
            request.namespaceName = this.namespaceName;
            request.labelName = this.labelName;
            request.labelDisplayText = this.labelDisplayText;
            request.isSystem = this.isSystem;
            request.labelPriority = this.labelPriority;
            request.isCountPop = this.isCountPop;
            request.isAliasPop = this.isAliasPop;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.labelSortBy = this.labelSortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum LabelSortBy implements BmcEnum
    {
        Name("name"),
        Priority("priority"),
        SourceUsing("sourceUsing");

        private final String value;
        private static Map<String, LabelSortBy> map;

        private LabelSortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LabelSortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LabelSortBy: " + key);
        }

        static {
            map = new HashMap<String, LabelSortBy>();
            for (LabelSortBy v : LabelSortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LabelPriority implements BmcEnum
    {
        None("NONE"),
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH");

        private final String value;
        private static Map<String, LabelPriority> map;

        private LabelPriority(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LabelPriority create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LabelPriority: " + key);
        }

        static {
            map = new HashMap<String, LabelPriority>();
            for (LabelPriority v : LabelPriority.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystem implements BmcEnum
    {
        All("ALL"),
        Custom("CUSTOM"),
        BuiltIn("BUILT_IN");

        private final String value;
        private static Map<String, IsSystem> map;

        private IsSystem(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystem create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSystem: " + key);
        }

        static {
            map = new HashMap<String, IsSystem>();
            for (IsSystem v : IsSystem.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

