/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.DisableAutoAssociationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DisableAutoAssociationRequest
extends BmcRequest<DisableAutoAssociationDetails> {
    private String namespaceName;
    private String sourceName;
    private DisableAutoAssociationDetails disableAutoAssociationDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public DisableAutoAssociationDetails getDisableAutoAssociationDetails() {
        return this.disableAutoAssociationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DisableAutoAssociationDetails getBody$() {
        return this.disableAutoAssociationDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).sourceName(this.sourceName).disableAutoAssociationDetails(this.disableAutoAssociationDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",sourceName=").append(String.valueOf(this.sourceName));
        sb.append(",disableAutoAssociationDetails=").append(String.valueOf((Object)this.disableAutoAssociationDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisableAutoAssociationRequest)) {
            return false;
        }
        DisableAutoAssociationRequest other = (DisableAutoAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals((Object)this.disableAutoAssociationDetails, (Object)other.disableAutoAssociationDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.disableAutoAssociationDetails == null ? 43 : this.disableAutoAssociationDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DisableAutoAssociationRequest, DisableAutoAssociationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String sourceName = null;
        private DisableAutoAssociationDetails disableAutoAssociationDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder disableAutoAssociationDetails(DisableAutoAssociationDetails disableAutoAssociationDetails) {
            this.disableAutoAssociationDetails = disableAutoAssociationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DisableAutoAssociationRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.sourceName(o.getSourceName());
            this.disableAutoAssociationDetails(o.getDisableAutoAssociationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DisableAutoAssociationRequest build() {
            DisableAutoAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DisableAutoAssociationDetails body) {
            this.disableAutoAssociationDetails(body);
            return this;
        }

        public DisableAutoAssociationRequest buildWithoutInvocationCallback() {
            DisableAutoAssociationRequest request = new DisableAutoAssociationRequest();
            request.namespaceName = this.namespaceName;
            request.sourceName = this.sourceName;
            request.disableAutoAssociationDetails = this.disableAutoAssociationDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

