/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractColumn;
import com.oracle.bmc.loganalytics.model.FieldValue;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class TrendColumn
extends AbstractColumn {
    @JsonProperty(value="intervalGap")
    private final String intervalGap;
    @JsonProperty(value="intervals")
    private final List<Long> intervals;
    @JsonProperty(value="totalIntervalCounts")
    private final List<Long> totalIntervalCounts;
    @JsonProperty(value="totalIntervalCountsAfterFilter")
    private final List<Long> totalIntervalCountsAfterFilter;
    @JsonProperty(value="intervalGroupCounts")
    private final List<Long> intervalGroupCounts;
    @JsonProperty(value="intervalGroupCountsAfterFilter")
    private final List<Long> intervalGroupCountsAfterFilter;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TrendColumn(String displayName, SubSystemName subSystem, List<FieldValue> values, Boolean isListOfValues, Boolean isMultiValued, Boolean isCaseSensitive, Boolean isGroupable, Boolean isEvaluable, ValueType valueType, String originalDisplayName, String internalName, String intervalGap, List<Long> intervals, List<Long> totalIntervalCounts, List<Long> totalIntervalCountsAfterFilter, List<Long> intervalGroupCounts, List<Long> intervalGroupCountsAfterFilter) {
        super(displayName, subSystem, values, isListOfValues, isMultiValued, isCaseSensitive, isGroupable, isEvaluable, valueType, originalDisplayName, internalName);
        this.intervalGap = intervalGap;
        this.intervals = intervals;
        this.totalIntervalCounts = totalIntervalCounts;
        this.totalIntervalCountsAfterFilter = totalIntervalCountsAfterFilter;
        this.intervalGroupCounts = intervalGroupCounts;
        this.intervalGroupCountsAfterFilter = intervalGroupCountsAfterFilter;
    }

    public String getIntervalGap() {
        return this.intervalGap;
    }

    public List<Long> getIntervals() {
        return this.intervals;
    }

    public List<Long> getTotalIntervalCounts() {
        return this.totalIntervalCounts;
    }

    public List<Long> getTotalIntervalCountsAfterFilter() {
        return this.totalIntervalCountsAfterFilter;
    }

    public List<Long> getIntervalGroupCounts() {
        return this.intervalGroupCounts;
    }

    public List<Long> getIntervalGroupCountsAfterFilter() {
        return this.intervalGroupCountsAfterFilter;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TrendColumn(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", intervalGap=").append(String.valueOf(this.intervalGap));
        sb.append(", intervals=").append(String.valueOf(this.intervals));
        sb.append(", totalIntervalCounts=").append(String.valueOf(this.totalIntervalCounts));
        sb.append(", totalIntervalCountsAfterFilter=").append(String.valueOf(this.totalIntervalCountsAfterFilter));
        sb.append(", intervalGroupCounts=").append(String.valueOf(this.intervalGroupCounts));
        sb.append(", intervalGroupCountsAfterFilter=").append(String.valueOf(this.intervalGroupCountsAfterFilter));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrendColumn)) {
            return false;
        }
        TrendColumn other = (TrendColumn)((Object)o);
        return Objects.equals(this.intervalGap, other.intervalGap) && Objects.equals(this.intervals, other.intervals) && Objects.equals(this.totalIntervalCounts, other.totalIntervalCounts) && Objects.equals(this.totalIntervalCountsAfterFilter, other.totalIntervalCountsAfterFilter) && Objects.equals(this.intervalGroupCounts, other.intervalGroupCounts) && Objects.equals(this.intervalGroupCountsAfterFilter, other.intervalGroupCountsAfterFilter) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.intervalGap == null ? 43 : this.intervalGap.hashCode());
        result = result * 59 + (this.intervals == null ? 43 : this.intervals.hashCode());
        result = result * 59 + (this.totalIntervalCounts == null ? 43 : this.totalIntervalCounts.hashCode());
        result = result * 59 + (this.totalIntervalCountsAfterFilter == null ? 43 : this.totalIntervalCountsAfterFilter.hashCode());
        result = result * 59 + (this.intervalGroupCounts == null ? 43 : this.intervalGroupCounts.hashCode());
        result = result * 59 + (this.intervalGroupCountsAfterFilter == null ? 43 : this.intervalGroupCountsAfterFilter.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="subSystem")
        private SubSystemName subSystem;
        @JsonProperty(value="values")
        private List<FieldValue> values;
        @JsonProperty(value="isListOfValues")
        private Boolean isListOfValues;
        @JsonProperty(value="isMultiValued")
        private Boolean isMultiValued;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonProperty(value="isGroupable")
        private Boolean isGroupable;
        @JsonProperty(value="isEvaluable")
        private Boolean isEvaluable;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonProperty(value="originalDisplayName")
        private String originalDisplayName;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="intervalGap")
        private String intervalGap;
        @JsonProperty(value="intervals")
        private List<Long> intervals;
        @JsonProperty(value="totalIntervalCounts")
        private List<Long> totalIntervalCounts;
        @JsonProperty(value="totalIntervalCountsAfterFilter")
        private List<Long> totalIntervalCountsAfterFilter;
        @JsonProperty(value="intervalGroupCounts")
        private List<Long> intervalGroupCounts;
        @JsonProperty(value="intervalGroupCountsAfterFilter")
        private List<Long> intervalGroupCountsAfterFilter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder subSystem(SubSystemName subSystem) {
            this.subSystem = subSystem;
            this.__explicitlySet__.add("subSystem");
            return this;
        }

        public Builder values(List<FieldValue> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public Builder isListOfValues(Boolean isListOfValues) {
            this.isListOfValues = isListOfValues;
            this.__explicitlySet__.add("isListOfValues");
            return this;
        }

        public Builder isMultiValued(Boolean isMultiValued) {
            this.isMultiValued = isMultiValued;
            this.__explicitlySet__.add("isMultiValued");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public Builder isGroupable(Boolean isGroupable) {
            this.isGroupable = isGroupable;
            this.__explicitlySet__.add("isGroupable");
            return this;
        }

        public Builder isEvaluable(Boolean isEvaluable) {
            this.isEvaluable = isEvaluable;
            this.__explicitlySet__.add("isEvaluable");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public Builder originalDisplayName(String originalDisplayName) {
            this.originalDisplayName = originalDisplayName;
            this.__explicitlySet__.add("originalDisplayName");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder intervalGap(String intervalGap) {
            this.intervalGap = intervalGap;
            this.__explicitlySet__.add("intervalGap");
            return this;
        }

        public Builder intervals(List<Long> intervals) {
            this.intervals = intervals;
            this.__explicitlySet__.add("intervals");
            return this;
        }

        public Builder totalIntervalCounts(List<Long> totalIntervalCounts) {
            this.totalIntervalCounts = totalIntervalCounts;
            this.__explicitlySet__.add("totalIntervalCounts");
            return this;
        }

        public Builder totalIntervalCountsAfterFilter(List<Long> totalIntervalCountsAfterFilter) {
            this.totalIntervalCountsAfterFilter = totalIntervalCountsAfterFilter;
            this.__explicitlySet__.add("totalIntervalCountsAfterFilter");
            return this;
        }

        public Builder intervalGroupCounts(List<Long> intervalGroupCounts) {
            this.intervalGroupCounts = intervalGroupCounts;
            this.__explicitlySet__.add("intervalGroupCounts");
            return this;
        }

        public Builder intervalGroupCountsAfterFilter(List<Long> intervalGroupCountsAfterFilter) {
            this.intervalGroupCountsAfterFilter = intervalGroupCountsAfterFilter;
            this.__explicitlySet__.add("intervalGroupCountsAfterFilter");
            return this;
        }

        public TrendColumn build() {
            TrendColumn model = new TrendColumn(this.displayName, this.subSystem, this.values, this.isListOfValues, this.isMultiValued, this.isCaseSensitive, this.isGroupable, this.isEvaluable, this.valueType, this.originalDisplayName, this.internalName, this.intervalGap, this.intervals, this.totalIntervalCounts, this.totalIntervalCountsAfterFilter, this.intervalGroupCounts, this.intervalGroupCountsAfterFilter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TrendColumn model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("subSystem")) {
                this.subSystem(model.getSubSystem());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            if (model.wasPropertyExplicitlySet("isListOfValues")) {
                this.isListOfValues(model.getIsListOfValues());
            }
            if (model.wasPropertyExplicitlySet("isMultiValued")) {
                this.isMultiValued(model.getIsMultiValued());
            }
            if (model.wasPropertyExplicitlySet("isCaseSensitive")) {
                this.isCaseSensitive(model.getIsCaseSensitive());
            }
            if (model.wasPropertyExplicitlySet("isGroupable")) {
                this.isGroupable(model.getIsGroupable());
            }
            if (model.wasPropertyExplicitlySet("isEvaluable")) {
                this.isEvaluable(model.getIsEvaluable());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            if (model.wasPropertyExplicitlySet("originalDisplayName")) {
                this.originalDisplayName(model.getOriginalDisplayName());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("intervalGap")) {
                this.intervalGap(model.getIntervalGap());
            }
            if (model.wasPropertyExplicitlySet("intervals")) {
                this.intervals(model.getIntervals());
            }
            if (model.wasPropertyExplicitlySet("totalIntervalCounts")) {
                this.totalIntervalCounts(model.getTotalIntervalCounts());
            }
            if (model.wasPropertyExplicitlySet("totalIntervalCountsAfterFilter")) {
                this.totalIntervalCountsAfterFilter(model.getTotalIntervalCountsAfterFilter());
            }
            if (model.wasPropertyExplicitlySet("intervalGroupCounts")) {
                this.intervalGroupCounts(model.getIntervalGroupCounts());
            }
            if (model.wasPropertyExplicitlySet("intervalGroupCountsAfterFilter")) {
                this.intervalGroupCountsAfterFilter(model.getIntervalGroupCountsAfterFilter());
            }
            return this;
        }
    }
}

