/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsLabelDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="editVersion")
    private final Long editVersion;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="sourceId")
    private final Long sourceId;
    @JsonProperty(value="labelName")
    private final String labelName;

    @Deprecated
    @ConstructorProperties(value={"editVersion", "isSystem", "sourceId", "labelName"})
    public LogAnalyticsLabelDefinition(Long editVersion, Boolean isSystem, Long sourceId, String labelName) {
        this.editVersion = editVersion;
        this.isSystem = isSystem;
        this.sourceId = sourceId;
        this.labelName = labelName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getEditVersion() {
        return this.editVersion;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsLabelDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("editVersion=").append(String.valueOf(this.editVersion));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", labelName=").append(String.valueOf(this.labelName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsLabelDefinition)) {
            return false;
        }
        LogAnalyticsLabelDefinition other = (LogAnalyticsLabelDefinition)((Object)o);
        return Objects.equals(this.editVersion, other.editVersion) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.labelName, other.labelName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.editVersion == null ? 43 : this.editVersion.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.labelName == null ? 43 : this.labelName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="editVersion")
        private Long editVersion;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="sourceId")
        private Long sourceId;
        @JsonProperty(value="labelName")
        private String labelName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder editVersion(Long editVersion) {
            this.editVersion = editVersion;
            this.__explicitlySet__.add("editVersion");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder sourceId(Long sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder labelName(String labelName) {
            this.labelName = labelName;
            this.__explicitlySet__.add("labelName");
            return this;
        }

        public LogAnalyticsLabelDefinition build() {
            LogAnalyticsLabelDefinition model = new LogAnalyticsLabelDefinition(this.editVersion, this.isSystem, this.sourceId, this.labelName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsLabelDefinition model) {
            if (model.wasPropertyExplicitlySet("editVersion")) {
                this.editVersion(model.getEditVersion());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("labelName")) {
                this.labelName(model.getLabelName());
            }
            return this;
        }
    }
}

