/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.EntityCloudType;
import com.oracle.bmc.loganalytics.model.EntityLifecycleStates;
import com.oracle.bmc.loganalytics.model.EntityTypeProperty;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsEntityType
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="internalName")
    private final String internalName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="category")
    private final String category;
    @JsonProperty(value="cloudType")
    private final EntityCloudType cloudType;
    @JsonProperty(value="properties")
    private final List<EntityTypeProperty> properties;
    @JsonProperty(value="lifecycleState")
    private final EntityLifecycleStates lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="managementAgentEligibilityStatus")
    private final ManagementAgentEligibilityStatus managementAgentEligibilityStatus;

    @Deprecated
    @ConstructorProperties(value={"name", "internalName", "compartmentId", "category", "cloudType", "properties", "lifecycleState", "timeCreated", "timeUpdated", "managementAgentEligibilityStatus"})
    public LogAnalyticsEntityType(String name, String internalName, String compartmentId, String category, EntityCloudType cloudType, List<EntityTypeProperty> properties, EntityLifecycleStates lifecycleState, Date timeCreated, Date timeUpdated, ManagementAgentEligibilityStatus managementAgentEligibilityStatus) {
        this.name = name;
        this.internalName = internalName;
        this.compartmentId = compartmentId;
        this.category = category;
        this.cloudType = cloudType;
        this.properties = properties;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.managementAgentEligibilityStatus = managementAgentEligibilityStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCategory() {
        return this.category;
    }

    public EntityCloudType getCloudType() {
        return this.cloudType;
    }

    public List<EntityTypeProperty> getProperties() {
        return this.properties;
    }

    public EntityLifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public ManagementAgentEligibilityStatus getManagementAgentEligibilityStatus() {
        return this.managementAgentEligibilityStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsEntityType(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", internalName=").append(String.valueOf(this.internalName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", category=").append(String.valueOf(this.category));
        sb.append(", cloudType=").append(String.valueOf((Object)this.cloudType));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", managementAgentEligibilityStatus=").append(String.valueOf((Object)this.managementAgentEligibilityStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsEntityType)) {
            return false;
        }
        LogAnalyticsEntityType other = (LogAnalyticsEntityType)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.internalName, other.internalName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.category, other.category) && Objects.equals((Object)this.cloudType, (Object)other.cloudType) && Objects.equals(this.properties, other.properties) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.managementAgentEligibilityStatus, (Object)other.managementAgentEligibilityStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.internalName == null ? 43 : this.internalName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.cloudType == null ? 43 : this.cloudType.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.managementAgentEligibilityStatus == null ? 43 : this.managementAgentEligibilityStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ManagementAgentEligibilityStatus implements BmcEnum
    {
        Eligible("ELIGIBLE"),
        Ineligible("INELIGIBLE"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagementAgentEligibilityStatus> map;

        private ManagementAgentEligibilityStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementAgentEligibilityStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagementAgentEligibilityStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagementAgentEligibilityStatus.class);
            map = new HashMap<String, ManagementAgentEligibilityStatus>();
            for (ManagementAgentEligibilityStatus v : ManagementAgentEligibilityStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="cloudType")
        private EntityCloudType cloudType;
        @JsonProperty(value="properties")
        private List<EntityTypeProperty> properties;
        @JsonProperty(value="lifecycleState")
        private EntityLifecycleStates lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="managementAgentEligibilityStatus")
        private ManagementAgentEligibilityStatus managementAgentEligibilityStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder cloudType(EntityCloudType cloudType) {
            this.cloudType = cloudType;
            this.__explicitlySet__.add("cloudType");
            return this;
        }

        public Builder properties(List<EntityTypeProperty> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public Builder lifecycleState(EntityLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder managementAgentEligibilityStatus(ManagementAgentEligibilityStatus managementAgentEligibilityStatus) {
            this.managementAgentEligibilityStatus = managementAgentEligibilityStatus;
            this.__explicitlySet__.add("managementAgentEligibilityStatus");
            return this;
        }

        public LogAnalyticsEntityType build() {
            LogAnalyticsEntityType model = new LogAnalyticsEntityType(this.name, this.internalName, this.compartmentId, this.category, this.cloudType, this.properties, this.lifecycleState, this.timeCreated, this.timeUpdated, this.managementAgentEligibilityStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsEntityType model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("cloudType")) {
                this.cloudType(model.getCloudType());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("managementAgentEligibilityStatus")) {
                this.managementAgentEligibilityStatus(model.getManagementAgentEligibilityStatus());
            }
            return this;
        }
    }
}

