/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsAssociation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="failureMessage")
    private final String failureMessage;
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="timeLastAttempted")
    private final Date timeLastAttempted;
    @JsonProperty(value="retryCount")
    private final Long retryCount;
    @JsonProperty(value="sourceName")
    private final String sourceName;
    @JsonProperty(value="sourceDisplayName")
    private final String sourceDisplayName;
    @JsonProperty(value="sourceTypeName")
    private final String sourceTypeName;
    @JsonProperty(value="lifeCycleState")
    private final LifeCycleState lifeCycleState;
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="entityTypeName")
    private final String entityTypeName;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="agentEntityName")
    private final String agentEntityName;
    @JsonProperty(value="entityTypeDisplayName")
    private final String entityTypeDisplayName;
    @JsonProperty(value="logGroupId")
    private final String logGroupId;
    @JsonProperty(value="logGroupName")
    private final String logGroupName;
    @JsonProperty(value="logGroupCompartment")
    private final String logGroupCompartment;

    @Deprecated
    @ConstructorProperties(value={"failureMessage", "agentId", "timeLastAttempted", "retryCount", "sourceName", "sourceDisplayName", "sourceTypeName", "lifeCycleState", "entityId", "entityName", "entityTypeName", "host", "agentEntityName", "entityTypeDisplayName", "logGroupId", "logGroupName", "logGroupCompartment"})
    public LogAnalyticsAssociation(String failureMessage, String agentId, Date timeLastAttempted, Long retryCount, String sourceName, String sourceDisplayName, String sourceTypeName, LifeCycleState lifeCycleState, String entityId, String entityName, String entityTypeName, String host, String agentEntityName, String entityTypeDisplayName, String logGroupId, String logGroupName, String logGroupCompartment) {
        this.failureMessage = failureMessage;
        this.agentId = agentId;
        this.timeLastAttempted = timeLastAttempted;
        this.retryCount = retryCount;
        this.sourceName = sourceName;
        this.sourceDisplayName = sourceDisplayName;
        this.sourceTypeName = sourceTypeName;
        this.lifeCycleState = lifeCycleState;
        this.entityId = entityId;
        this.entityName = entityName;
        this.entityTypeName = entityTypeName;
        this.host = host;
        this.agentEntityName = agentEntityName;
        this.entityTypeDisplayName = entityTypeDisplayName;
        this.logGroupId = logGroupId;
        this.logGroupName = logGroupName;
        this.logGroupCompartment = logGroupCompartment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public Date getTimeLastAttempted() {
        return this.timeLastAttempted;
    }

    public Long getRetryCount() {
        return this.retryCount;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getHost() {
        return this.host;
    }

    public String getAgentEntityName() {
        return this.agentEntityName;
    }

    public String getEntityTypeDisplayName() {
        return this.entityTypeDisplayName;
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public String getLogGroupCompartment() {
        return this.logGroupCompartment;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsAssociation(");
        sb.append("super=").append(super.toString());
        sb.append("failureMessage=").append(String.valueOf(this.failureMessage));
        sb.append(", agentId=").append(String.valueOf(this.agentId));
        sb.append(", timeLastAttempted=").append(String.valueOf(this.timeLastAttempted));
        sb.append(", retryCount=").append(String.valueOf(this.retryCount));
        sb.append(", sourceName=").append(String.valueOf(this.sourceName));
        sb.append(", sourceDisplayName=").append(String.valueOf(this.sourceDisplayName));
        sb.append(", sourceTypeName=").append(String.valueOf(this.sourceTypeName));
        sb.append(", lifeCycleState=").append(String.valueOf((Object)this.lifeCycleState));
        sb.append(", entityId=").append(String.valueOf(this.entityId));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(", entityTypeName=").append(String.valueOf(this.entityTypeName));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", agentEntityName=").append(String.valueOf(this.agentEntityName));
        sb.append(", entityTypeDisplayName=").append(String.valueOf(this.entityTypeDisplayName));
        sb.append(", logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(", logGroupName=").append(String.valueOf(this.logGroupName));
        sb.append(", logGroupCompartment=").append(String.valueOf(this.logGroupCompartment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsAssociation)) {
            return false;
        }
        LogAnalyticsAssociation other = (LogAnalyticsAssociation)((Object)o);
        return Objects.equals(this.failureMessage, other.failureMessage) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.timeLastAttempted, other.timeLastAttempted) && Objects.equals(this.retryCount, other.retryCount) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals(this.sourceDisplayName, other.sourceDisplayName) && Objects.equals(this.sourceTypeName, other.sourceTypeName) && Objects.equals((Object)this.lifeCycleState, (Object)other.lifeCycleState) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.entityTypeName, other.entityTypeName) && Objects.equals(this.host, other.host) && Objects.equals(this.agentEntityName, other.agentEntityName) && Objects.equals(this.entityTypeDisplayName, other.entityTypeDisplayName) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals(this.logGroupName, other.logGroupName) && Objects.equals(this.logGroupCompartment, other.logGroupCompartment) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.failureMessage == null ? 43 : this.failureMessage.hashCode());
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.timeLastAttempted == null ? 43 : this.timeLastAttempted.hashCode());
        result = result * 59 + (this.retryCount == null ? 43 : this.retryCount.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.sourceDisplayName == null ? 43 : this.sourceDisplayName.hashCode());
        result = result * 59 + (this.sourceTypeName == null ? 43 : this.sourceTypeName.hashCode());
        result = result * 59 + (this.lifeCycleState == null ? 43 : this.lifeCycleState.hashCode());
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityTypeName == null ? 43 : this.entityTypeName.hashCode());
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.agentEntityName == null ? 43 : this.agentEntityName.hashCode());
        result = result * 59 + (this.entityTypeDisplayName == null ? 43 : this.entityTypeDisplayName.hashCode());
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.logGroupName == null ? 43 : this.logGroupName.hashCode());
        result = result * 59 + (this.logGroupCompartment == null ? 43 : this.logGroupCompartment.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifeCycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifeCycleState> map;

        private LifeCycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifeCycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifeCycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifeCycleState.class);
            map = new HashMap<String, LifeCycleState>();
            for (LifeCycleState v : LifeCycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="failureMessage")
        private String failureMessage;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="timeLastAttempted")
        private Date timeLastAttempted;
        @JsonProperty(value="retryCount")
        private Long retryCount;
        @JsonProperty(value="sourceName")
        private String sourceName;
        @JsonProperty(value="sourceDisplayName")
        private String sourceDisplayName;
        @JsonProperty(value="sourceTypeName")
        private String sourceTypeName;
        @JsonProperty(value="lifeCycleState")
        private LifeCycleState lifeCycleState;
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="entityTypeName")
        private String entityTypeName;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="agentEntityName")
        private String agentEntityName;
        @JsonProperty(value="entityTypeDisplayName")
        private String entityTypeDisplayName;
        @JsonProperty(value="logGroupId")
        private String logGroupId;
        @JsonProperty(value="logGroupName")
        private String logGroupName;
        @JsonProperty(value="logGroupCompartment")
        private String logGroupCompartment;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            this.__explicitlySet__.add("failureMessage");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder timeLastAttempted(Date timeLastAttempted) {
            this.timeLastAttempted = timeLastAttempted;
            this.__explicitlySet__.add("timeLastAttempted");
            return this;
        }

        public Builder retryCount(Long retryCount) {
            this.retryCount = retryCount;
            this.__explicitlySet__.add("retryCount");
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            this.__explicitlySet__.add("sourceName");
            return this;
        }

        public Builder sourceDisplayName(String sourceDisplayName) {
            this.sourceDisplayName = sourceDisplayName;
            this.__explicitlySet__.add("sourceDisplayName");
            return this;
        }

        public Builder sourceTypeName(String sourceTypeName) {
            this.sourceTypeName = sourceTypeName;
            this.__explicitlySet__.add("sourceTypeName");
            return this;
        }

        public Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            this.__explicitlySet__.add("lifeCycleState");
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder entityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            this.__explicitlySet__.add("entityTypeName");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder agentEntityName(String agentEntityName) {
            this.agentEntityName = agentEntityName;
            this.__explicitlySet__.add("agentEntityName");
            return this;
        }

        public Builder entityTypeDisplayName(String entityTypeDisplayName) {
            this.entityTypeDisplayName = entityTypeDisplayName;
            this.__explicitlySet__.add("entityTypeDisplayName");
            return this;
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            this.__explicitlySet__.add("logGroupId");
            return this;
        }

        public Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            this.__explicitlySet__.add("logGroupName");
            return this;
        }

        public Builder logGroupCompartment(String logGroupCompartment) {
            this.logGroupCompartment = logGroupCompartment;
            this.__explicitlySet__.add("logGroupCompartment");
            return this;
        }

        public LogAnalyticsAssociation build() {
            LogAnalyticsAssociation model = new LogAnalyticsAssociation(this.failureMessage, this.agentId, this.timeLastAttempted, this.retryCount, this.sourceName, this.sourceDisplayName, this.sourceTypeName, this.lifeCycleState, this.entityId, this.entityName, this.entityTypeName, this.host, this.agentEntityName, this.entityTypeDisplayName, this.logGroupId, this.logGroupName, this.logGroupCompartment);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsAssociation model) {
            if (model.wasPropertyExplicitlySet("failureMessage")) {
                this.failureMessage(model.getFailureMessage());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("timeLastAttempted")) {
                this.timeLastAttempted(model.getTimeLastAttempted());
            }
            if (model.wasPropertyExplicitlySet("retryCount")) {
                this.retryCount(model.getRetryCount());
            }
            if (model.wasPropertyExplicitlySet("sourceName")) {
                this.sourceName(model.getSourceName());
            }
            if (model.wasPropertyExplicitlySet("sourceDisplayName")) {
                this.sourceDisplayName(model.getSourceDisplayName());
            }
            if (model.wasPropertyExplicitlySet("sourceTypeName")) {
                this.sourceTypeName(model.getSourceTypeName());
            }
            if (model.wasPropertyExplicitlySet("lifeCycleState")) {
                this.lifeCycleState(model.getLifeCycleState());
            }
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityTypeName")) {
                this.entityTypeName(model.getEntityTypeName());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("agentEntityName")) {
                this.agentEntityName(model.getAgentEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityTypeDisplayName")) {
                this.entityTypeDisplayName(model.getEntityTypeDisplayName());
            }
            if (model.wasPropertyExplicitlySet("logGroupId")) {
                this.logGroupId(model.getLogGroupId());
            }
            if (model.wasPropertyExplicitlySet("logGroupName")) {
                this.logGroupName(model.getLogGroupName());
            }
            if (model.wasPropertyExplicitlySet("logGroupCompartment")) {
                this.logGroupCompartment(model.getLogGroupCompartment());
            }
            return this;
        }
    }
}

