/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportContent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fieldNames")
    private final List<String> fieldNames;
    @JsonProperty(value="parserNames")
    private final List<String> parserNames;
    @JsonProperty(value="sourceNames")
    private final List<String> sourceNames;

    @Deprecated
    @ConstructorProperties(value={"fieldNames", "parserNames", "sourceNames"})
    public ExportContent(List<String> fieldNames, List<String> parserNames, List<String> sourceNames) {
        this.fieldNames = fieldNames;
        this.parserNames = parserNames;
        this.sourceNames = sourceNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<String> getParserNames() {
        return this.parserNames;
    }

    public List<String> getSourceNames() {
        return this.sourceNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportContent(");
        sb.append("super=").append(super.toString());
        sb.append("fieldNames=").append(String.valueOf(this.fieldNames));
        sb.append(", parserNames=").append(String.valueOf(this.parserNames));
        sb.append(", sourceNames=").append(String.valueOf(this.sourceNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportContent)) {
            return false;
        }
        ExportContent other = (ExportContent)((Object)o);
        return Objects.equals(this.fieldNames, other.fieldNames) && Objects.equals(this.parserNames, other.parserNames) && Objects.equals(this.sourceNames, other.sourceNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fieldNames == null ? 43 : this.fieldNames.hashCode());
        result = result * 59 + (this.parserNames == null ? 43 : this.parserNames.hashCode());
        result = result * 59 + (this.sourceNames == null ? 43 : this.sourceNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldNames")
        private List<String> fieldNames;
        @JsonProperty(value="parserNames")
        private List<String> parserNames;
        @JsonProperty(value="sourceNames")
        private List<String> sourceNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldNames(List<String> fieldNames) {
            this.fieldNames = fieldNames;
            this.__explicitlySet__.add("fieldNames");
            return this;
        }

        public Builder parserNames(List<String> parserNames) {
            this.parserNames = parserNames;
            this.__explicitlySet__.add("parserNames");
            return this;
        }

        public Builder sourceNames(List<String> sourceNames) {
            this.sourceNames = sourceNames;
            this.__explicitlySet__.add("sourceNames");
            return this;
        }

        public ExportContent build() {
            ExportContent model = new ExportContent(this.fieldNames, this.parserNames, this.sourceNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportContent model) {
            if (model.wasPropertyExplicitlySet("fieldNames")) {
                this.fieldNames(model.getFieldNames());
            }
            if (model.wasPropertyExplicitlySet("parserNames")) {
                this.parserNames(model.getParserNames());
            }
            if (model.wasPropertyExplicitlySet("sourceNames")) {
                this.sourceNames(model.getSourceNames());
            }
            return this;
        }
    }
}

