/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EventType
extends ExplicitlySetBmcModel {
    @JsonProperty(value="eventTypeName")
    private final String eventTypeName;
    @JsonProperty(value="specVersion")
    private final String specVersion;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"eventTypeName", "specVersion", "isEnabled", "isSystem", "timeUpdated"})
    public EventType(String eventTypeName, String specVersion, Boolean isEnabled, Boolean isSystem, Date timeUpdated) {
        this.eventTypeName = eventTypeName;
        this.specVersion = specVersion;
        this.isEnabled = isEnabled;
        this.isSystem = isSystem;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EventType(");
        sb.append("super=").append(super.toString());
        sb.append("eventTypeName=").append(String.valueOf(this.eventTypeName));
        sb.append(", specVersion=").append(String.valueOf(this.specVersion));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)((Object)o);
        return Objects.equals(this.eventTypeName, other.eventTypeName) && Objects.equals(this.specVersion, other.specVersion) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.eventTypeName == null ? 43 : this.eventTypeName.hashCode());
        result = result * 59 + (this.specVersion == null ? 43 : this.specVersion.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="eventTypeName")
        private String eventTypeName;
        @JsonProperty(value="specVersion")
        private String specVersion;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            this.__explicitlySet__.add("eventTypeName");
            return this;
        }

        public Builder specVersion(String specVersion) {
            this.specVersion = specVersion;
            this.__explicitlySet__.add("specVersion");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public EventType build() {
            EventType model = new EventType(this.eventTypeName, this.specVersion, this.isEnabled, this.isSystem, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EventType model) {
            if (model.wasPropertyExplicitlySet("eventTypeName")) {
                this.eventTypeName(model.getEventTypeName());
            }
            if (model.wasPropertyExplicitlySet("specVersion")) {
                this.specVersion(model.getSpecVersion());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

