/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.FieldsAddRemoveField;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class ClassifyCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="topCount")
    private final Integer topCount;
    @JsonProperty(value="bottomCount")
    private final Integer bottomCount;
    @JsonProperty(value="correlate")
    private final List<FieldsAddRemoveField> correlate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ClassifyCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, Integer topCount, Integer bottomCount, List<FieldsAddRemoveField> correlate) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.topCount = topCount;
        this.bottomCount = bottomCount;
        this.correlate = correlate;
    }

    public Integer getTopCount() {
        return this.topCount;
    }

    public Integer getBottomCount() {
        return this.bottomCount;
    }

    public List<FieldsAddRemoveField> getCorrelate() {
        return this.correlate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassifyCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", topCount=").append(String.valueOf(this.topCount));
        sb.append(", bottomCount=").append(String.valueOf(this.bottomCount));
        sb.append(", correlate=").append(String.valueOf(this.correlate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassifyCommandDescriptor)) {
            return false;
        }
        ClassifyCommandDescriptor other = (ClassifyCommandDescriptor)((Object)o);
        return Objects.equals(this.topCount, other.topCount) && Objects.equals(this.bottomCount, other.bottomCount) && Objects.equals(this.correlate, other.correlate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.topCount == null ? 43 : this.topCount.hashCode());
        result = result * 59 + (this.bottomCount == null ? 43 : this.bottomCount.hashCode());
        result = result * 59 + (this.correlate == null ? 43 : this.correlate.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="topCount")
        private Integer topCount;
        @JsonProperty(value="bottomCount")
        private Integer bottomCount;
        @JsonProperty(value="correlate")
        private List<FieldsAddRemoveField> correlate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder topCount(Integer topCount) {
            this.topCount = topCount;
            this.__explicitlySet__.add("topCount");
            return this;
        }

        public Builder bottomCount(Integer bottomCount) {
            this.bottomCount = bottomCount;
            this.__explicitlySet__.add("bottomCount");
            return this;
        }

        public Builder correlate(List<FieldsAddRemoveField> correlate) {
            this.correlate = correlate;
            this.__explicitlySet__.add("correlate");
            return this;
        }

        public ClassifyCommandDescriptor build() {
            ClassifyCommandDescriptor model = new ClassifyCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.topCount, this.bottomCount, this.correlate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClassifyCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("topCount")) {
                this.topCount(model.getTopCount());
            }
            if (model.wasPropertyExplicitlySet("bottomCount")) {
                this.bottomCount(model.getBottomCount());
            }
            if (model.wasPropertyExplicitlySet("correlate")) {
                this.correlate(model.getCorrelate());
            }
            return this;
        }
    }
}

