/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAccessMaterialsRequest
extends BmcRequest<Void> {
    private String accessRequestId;
    private String opcRequestId;

    public String getAccessRequestId() {
        return this.accessRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().accessRequestId(this.accessRequestId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",accessRequestId=").append(String.valueOf(this.accessRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAccessMaterialsRequest)) {
            return false;
        }
        GetAccessMaterialsRequest other = (GetAccessMaterialsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.accessRequestId, other.accessRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessRequestId == null ? 43 : this.accessRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAccessMaterialsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String accessRequestId = null;
        private String opcRequestId = null;

        public Builder accessRequestId(String accessRequestId) {
            this.accessRequestId = accessRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAccessMaterialsRequest o) {
            this.accessRequestId(o.getAccessRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAccessMaterialsRequest build() {
            GetAccessMaterialsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAccessMaterialsRequest buildWithoutInvocationCallback() {
            GetAccessMaterialsRequest request = new GetAccessMaterialsRequest();
            request.accessRequestId = this.accessRequestId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

