/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.lockbox.model.AccessContextAttributeCollection;
import com.oracle.bmc.lockbox.model.LockboxPartner;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateLockboxDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="lockboxPartner")
    private final LockboxPartner lockboxPartner;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="partnerCompartmentId")
    private final String partnerCompartmentId;
    @JsonProperty(value="approvalTemplateId")
    private final String approvalTemplateId;
    @JsonProperty(value="maxAccessDuration")
    private final String maxAccessDuration;
    @JsonProperty(value="accessContextAttributes")
    private final AccessContextAttributeCollection accessContextAttributes;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "resourceId", "lockboxPartner", "compartmentId", "partnerCompartmentId", "approvalTemplateId", "maxAccessDuration", "accessContextAttributes", "freeformTags", "definedTags"})
    public CreateLockboxDetails(String displayName, String resourceId, LockboxPartner lockboxPartner, String compartmentId, String partnerCompartmentId, String approvalTemplateId, String maxAccessDuration, AccessContextAttributeCollection accessContextAttributes, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.resourceId = resourceId;
        this.lockboxPartner = lockboxPartner;
        this.compartmentId = compartmentId;
        this.partnerCompartmentId = partnerCompartmentId;
        this.approvalTemplateId = approvalTemplateId;
        this.maxAccessDuration = maxAccessDuration;
        this.accessContextAttributes = accessContextAttributes;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public LockboxPartner getLockboxPartner() {
        return this.lockboxPartner;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPartnerCompartmentId() {
        return this.partnerCompartmentId;
    }

    public String getApprovalTemplateId() {
        return this.approvalTemplateId;
    }

    public String getMaxAccessDuration() {
        return this.maxAccessDuration;
    }

    public AccessContextAttributeCollection getAccessContextAttributes() {
        return this.accessContextAttributes;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateLockboxDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", lockboxPartner=").append(String.valueOf((Object)this.lockboxPartner));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", partnerCompartmentId=").append(String.valueOf(this.partnerCompartmentId));
        sb.append(", approvalTemplateId=").append(String.valueOf(this.approvalTemplateId));
        sb.append(", maxAccessDuration=").append(String.valueOf(this.maxAccessDuration));
        sb.append(", accessContextAttributes=").append(String.valueOf((Object)this.accessContextAttributes));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateLockboxDetails)) {
            return false;
        }
        CreateLockboxDetails other = (CreateLockboxDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.lockboxPartner, (Object)other.lockboxPartner) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.partnerCompartmentId, other.partnerCompartmentId) && Objects.equals(this.approvalTemplateId, other.approvalTemplateId) && Objects.equals(this.maxAccessDuration, other.maxAccessDuration) && Objects.equals((Object)this.accessContextAttributes, (Object)other.accessContextAttributes) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.lockboxPartner == null ? 43 : this.lockboxPartner.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.partnerCompartmentId == null ? 43 : this.partnerCompartmentId.hashCode());
        result = result * 59 + (this.approvalTemplateId == null ? 43 : this.approvalTemplateId.hashCode());
        result = result * 59 + (this.maxAccessDuration == null ? 43 : this.maxAccessDuration.hashCode());
        result = result * 59 + (this.accessContextAttributes == null ? 43 : this.accessContextAttributes.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="lockboxPartner")
        private LockboxPartner lockboxPartner;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="partnerCompartmentId")
        private String partnerCompartmentId;
        @JsonProperty(value="approvalTemplateId")
        private String approvalTemplateId;
        @JsonProperty(value="maxAccessDuration")
        private String maxAccessDuration;
        @JsonProperty(value="accessContextAttributes")
        private AccessContextAttributeCollection accessContextAttributes;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder lockboxPartner(LockboxPartner lockboxPartner) {
            this.lockboxPartner = lockboxPartner;
            this.__explicitlySet__.add("lockboxPartner");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder partnerCompartmentId(String partnerCompartmentId) {
            this.partnerCompartmentId = partnerCompartmentId;
            this.__explicitlySet__.add("partnerCompartmentId");
            return this;
        }

        public Builder approvalTemplateId(String approvalTemplateId) {
            this.approvalTemplateId = approvalTemplateId;
            this.__explicitlySet__.add("approvalTemplateId");
            return this;
        }

        public Builder maxAccessDuration(String maxAccessDuration) {
            this.maxAccessDuration = maxAccessDuration;
            this.__explicitlySet__.add("maxAccessDuration");
            return this;
        }

        public Builder accessContextAttributes(AccessContextAttributeCollection accessContextAttributes) {
            this.accessContextAttributes = accessContextAttributes;
            this.__explicitlySet__.add("accessContextAttributes");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateLockboxDetails build() {
            CreateLockboxDetails model = new CreateLockboxDetails(this.displayName, this.resourceId, this.lockboxPartner, this.compartmentId, this.partnerCompartmentId, this.approvalTemplateId, this.maxAccessDuration, this.accessContextAttributes, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateLockboxDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("lockboxPartner")) {
                this.lockboxPartner(model.getLockboxPartner());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("partnerCompartmentId")) {
                this.partnerCompartmentId(model.getPartnerCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("approvalTemplateId")) {
                this.approvalTemplateId(model.getApprovalTemplateId());
            }
            if (model.wasPropertyExplicitlySet("maxAccessDuration")) {
                this.maxAccessDuration(model.getMaxAccessDuration());
            }
            if (model.wasPropertyExplicitlySet("accessContextAttributes")) {
                this.accessContextAttributes(model.getAccessContextAttributes());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

