/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteCertificateRequest
extends BmcRequest<Void> {
    private String loadBalancerId;
    private String certificateName;
    private String opcRequestId;
    private String ifMatch;

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().loadBalancerId(this.loadBalancerId).certificateName(this.certificateName).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",loadBalancerId=").append(String.valueOf(this.loadBalancerId));
        sb.append(",certificateName=").append(String.valueOf(this.certificateName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteCertificateRequest)) {
            return false;
        }
        DeleteCertificateRequest other = (DeleteCertificateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.loadBalancerId, other.loadBalancerId) && Objects.equals(this.certificateName, other.certificateName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.loadBalancerId == null ? 43 : this.loadBalancerId.hashCode());
        result = result * 59 + (this.certificateName == null ? 43 : this.certificateName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteCertificateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String loadBalancerId = null;
        private String certificateName = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCertificateRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.certificateName(o.getCertificateName());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCertificateRequest build() {
            DeleteCertificateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteCertificateRequest buildWithoutInvocationCallback() {
            DeleteCertificateRequest request = new DeleteCertificateRequest();
            request.loadBalancerId = this.loadBalancerId;
            request.certificateName = this.certificateName;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

