/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loadbalancer.model.RoutingRule;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateRoutingPolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="conditionLanguageVersion")
    private final ConditionLanguageVersion conditionLanguageVersion;
    @JsonProperty(value="rules")
    private final List<RoutingRule> rules;

    @Deprecated
    @ConstructorProperties(value={"conditionLanguageVersion", "rules"})
    public UpdateRoutingPolicyDetails(ConditionLanguageVersion conditionLanguageVersion, List<RoutingRule> rules) {
        this.conditionLanguageVersion = conditionLanguageVersion;
        this.rules = rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ConditionLanguageVersion getConditionLanguageVersion() {
        return this.conditionLanguageVersion;
    }

    public List<RoutingRule> getRules() {
        return this.rules;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateRoutingPolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("conditionLanguageVersion=").append(String.valueOf((Object)this.conditionLanguageVersion));
        sb.append(", rules=").append(String.valueOf(this.rules));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRoutingPolicyDetails)) {
            return false;
        }
        UpdateRoutingPolicyDetails other = (UpdateRoutingPolicyDetails)((Object)o);
        return Objects.equals((Object)this.conditionLanguageVersion, (Object)other.conditionLanguageVersion) && Objects.equals(this.rules, other.rules) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.conditionLanguageVersion == null ? 43 : this.conditionLanguageVersion.hashCode());
        result = result * 59 + (this.rules == null ? 43 : this.rules.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConditionLanguageVersion implements BmcEnum
    {
        V1("V1");

        private final String value;
        private static Map<String, ConditionLanguageVersion> map;

        private ConditionLanguageVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConditionLanguageVersion create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConditionLanguageVersion: " + key);
        }

        static {
            map = new HashMap<String, ConditionLanguageVersion>();
            for (ConditionLanguageVersion v : ConditionLanguageVersion.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="conditionLanguageVersion")
        private ConditionLanguageVersion conditionLanguageVersion;
        @JsonProperty(value="rules")
        private List<RoutingRule> rules;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder conditionLanguageVersion(ConditionLanguageVersion conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
            this.__explicitlySet__.add("conditionLanguageVersion");
            return this;
        }

        public Builder rules(List<RoutingRule> rules) {
            this.rules = rules;
            this.__explicitlySet__.add("rules");
            return this;
        }

        public UpdateRoutingPolicyDetails build() {
            UpdateRoutingPolicyDetails model = new UpdateRoutingPolicyDetails(this.conditionLanguageVersion, this.rules);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateRoutingPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("conditionLanguageVersion")) {
                this.conditionLanguageVersion(model.getConditionLanguageVersion());
            }
            if (model.wasPropertyExplicitlySet("rules")) {
                this.rules(model.getRules());
            }
            return this;
        }
    }
}

