/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateHealthCheckerDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="urlPath")
    private final String urlPath;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="returnCode")
    private final Integer returnCode;
    @JsonProperty(value="retries")
    private final Integer retries;
    @JsonProperty(value="timeoutInMillis")
    private final Integer timeoutInMillis;
    @JsonProperty(value="intervalInMillis")
    private final Integer intervalInMillis;
    @JsonProperty(value="responseBodyRegex")
    private final String responseBodyRegex;

    @Deprecated
    @ConstructorProperties(value={"protocol", "urlPath", "port", "returnCode", "retries", "timeoutInMillis", "intervalInMillis", "responseBodyRegex"})
    public UpdateHealthCheckerDetails(String protocol, String urlPath, Integer port, Integer returnCode, Integer retries, Integer timeoutInMillis, Integer intervalInMillis, String responseBodyRegex) {
        this.protocol = protocol;
        this.urlPath = urlPath;
        this.port = port;
        this.returnCode = returnCode;
        this.retries = retries;
        this.timeoutInMillis = timeoutInMillis;
        this.intervalInMillis = intervalInMillis;
        this.responseBodyRegex = responseBodyRegex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getReturnCode() {
        return this.returnCode;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Integer getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public Integer getIntervalInMillis() {
        return this.intervalInMillis;
    }

    public String getResponseBodyRegex() {
        return this.responseBodyRegex;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateHealthCheckerDetails(");
        sb.append("super=").append(super.toString());
        sb.append("protocol=").append(String.valueOf(this.protocol));
        sb.append(", urlPath=").append(String.valueOf(this.urlPath));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", returnCode=").append(String.valueOf(this.returnCode));
        sb.append(", retries=").append(String.valueOf(this.retries));
        sb.append(", timeoutInMillis=").append(String.valueOf(this.timeoutInMillis));
        sb.append(", intervalInMillis=").append(String.valueOf(this.intervalInMillis));
        sb.append(", responseBodyRegex=").append(String.valueOf(this.responseBodyRegex));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateHealthCheckerDetails)) {
            return false;
        }
        UpdateHealthCheckerDetails other = (UpdateHealthCheckerDetails)((Object)o);
        return Objects.equals(this.protocol, other.protocol) && Objects.equals(this.urlPath, other.urlPath) && Objects.equals(this.port, other.port) && Objects.equals(this.returnCode, other.returnCode) && Objects.equals(this.retries, other.retries) && Objects.equals(this.timeoutInMillis, other.timeoutInMillis) && Objects.equals(this.intervalInMillis, other.intervalInMillis) && Objects.equals(this.responseBodyRegex, other.responseBodyRegex) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.urlPath == null ? 43 : this.urlPath.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.returnCode == null ? 43 : this.returnCode.hashCode());
        result = result * 59 + (this.retries == null ? 43 : this.retries.hashCode());
        result = result * 59 + (this.timeoutInMillis == null ? 43 : this.timeoutInMillis.hashCode());
        result = result * 59 + (this.intervalInMillis == null ? 43 : this.intervalInMillis.hashCode());
        result = result * 59 + (this.responseBodyRegex == null ? 43 : this.responseBodyRegex.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="urlPath")
        private String urlPath;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="returnCode")
        private Integer returnCode;
        @JsonProperty(value="retries")
        private Integer retries;
        @JsonProperty(value="timeoutInMillis")
        private Integer timeoutInMillis;
        @JsonProperty(value="intervalInMillis")
        private Integer intervalInMillis;
        @JsonProperty(value="responseBodyRegex")
        private String responseBodyRegex;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder urlPath(String urlPath) {
            this.urlPath = urlPath;
            this.__explicitlySet__.add("urlPath");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder returnCode(Integer returnCode) {
            this.returnCode = returnCode;
            this.__explicitlySet__.add("returnCode");
            return this;
        }

        public Builder retries(Integer retries) {
            this.retries = retries;
            this.__explicitlySet__.add("retries");
            return this;
        }

        public Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            this.__explicitlySet__.add("timeoutInMillis");
            return this;
        }

        public Builder intervalInMillis(Integer intervalInMillis) {
            this.intervalInMillis = intervalInMillis;
            this.__explicitlySet__.add("intervalInMillis");
            return this;
        }

        public Builder responseBodyRegex(String responseBodyRegex) {
            this.responseBodyRegex = responseBodyRegex;
            this.__explicitlySet__.add("responseBodyRegex");
            return this;
        }

        public UpdateHealthCheckerDetails build() {
            UpdateHealthCheckerDetails model = new UpdateHealthCheckerDetails(this.protocol, this.urlPath, this.port, this.returnCode, this.retries, this.timeoutInMillis, this.intervalInMillis, this.responseBodyRegex);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateHealthCheckerDetails model) {
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("urlPath")) {
                this.urlPath(model.getUrlPath());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("returnCode")) {
                this.returnCode(model.getReturnCode());
            }
            if (model.wasPropertyExplicitlySet("retries")) {
                this.retries(model.getRetries());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMillis")) {
                this.timeoutInMillis(model.getTimeoutInMillis());
            }
            if (model.wasPropertyExplicitlySet("intervalInMillis")) {
                this.intervalInMillis(model.getIntervalInMillis());
            }
            if (model.wasPropertyExplicitlySet("responseBodyRegex")) {
                this.responseBodyRegex(model.getResponseBodyRegex());
            }
            return this;
        }
    }
}

