/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.oracle.bmc.limits.Limits;
import com.oracle.bmc.limits.model.LimitDefinitionSummary;
import com.oracle.bmc.limits.model.LimitValueSummary;
import com.oracle.bmc.limits.model.ServiceSummary;
import com.oracle.bmc.limits.requests.ListLimitDefinitionsRequest;
import com.oracle.bmc.limits.requests.ListLimitValuesRequest;
import com.oracle.bmc.limits.requests.ListServicesRequest;
import com.oracle.bmc.limits.responses.ListLimitDefinitionsResponse;
import com.oracle.bmc.limits.responses.ListLimitValuesResponse;
import com.oracle.bmc.limits.responses.ListServicesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class LimitsPaginators {
    private final Limits client;

    public LimitsPaginators(Limits client) {
        this.client = client;
    }

    public Iterable<ListLimitDefinitionsResponse> listLimitDefinitionsResponseIterator(final ListLimitDefinitionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLimitDefinitionsRequest.Builder>(){

            @Override
            public ListLimitDefinitionsRequest.Builder get() {
                return ListLimitDefinitionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLimitDefinitionsResponse, String>(){

            @Override
            public String apply(ListLimitDefinitionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLimitDefinitionsRequest.Builder>, ListLimitDefinitionsRequest>(){

            @Override
            public ListLimitDefinitionsRequest apply(RequestBuilderAndToken<ListLimitDefinitionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLimitDefinitionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLimitDefinitionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse>(){

            @Override
            public ListLimitDefinitionsResponse apply(ListLimitDefinitionsRequest request) {
                return LimitsPaginators.this.client.listLimitDefinitions(request);
            }
        });
    }

    public Iterable<LimitDefinitionSummary> listLimitDefinitionsRecordIterator(final ListLimitDefinitionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLimitDefinitionsRequest.Builder>(){

            @Override
            public ListLimitDefinitionsRequest.Builder get() {
                return ListLimitDefinitionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLimitDefinitionsResponse, String>(){

            @Override
            public String apply(ListLimitDefinitionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLimitDefinitionsRequest.Builder>, ListLimitDefinitionsRequest>(){

            @Override
            public ListLimitDefinitionsRequest apply(RequestBuilderAndToken<ListLimitDefinitionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLimitDefinitionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLimitDefinitionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse>(){

            @Override
            public ListLimitDefinitionsResponse apply(ListLimitDefinitionsRequest request) {
                return LimitsPaginators.this.client.listLimitDefinitions(request);
            }
        }, (Function)new Function<ListLimitDefinitionsResponse, List<LimitDefinitionSummary>>(){

            @Override
            public List<LimitDefinitionSummary> apply(ListLimitDefinitionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListLimitValuesResponse> listLimitValuesResponseIterator(final ListLimitValuesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLimitValuesRequest.Builder>(){

            @Override
            public ListLimitValuesRequest.Builder get() {
                return ListLimitValuesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLimitValuesResponse, String>(){

            @Override
            public String apply(ListLimitValuesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLimitValuesRequest.Builder>, ListLimitValuesRequest>(){

            @Override
            public ListLimitValuesRequest apply(RequestBuilderAndToken<ListLimitValuesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLimitValuesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLimitValuesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLimitValuesRequest, ListLimitValuesResponse>(){

            @Override
            public ListLimitValuesResponse apply(ListLimitValuesRequest request) {
                return LimitsPaginators.this.client.listLimitValues(request);
            }
        });
    }

    public Iterable<LimitValueSummary> listLimitValuesRecordIterator(final ListLimitValuesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLimitValuesRequest.Builder>(){

            @Override
            public ListLimitValuesRequest.Builder get() {
                return ListLimitValuesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLimitValuesResponse, String>(){

            @Override
            public String apply(ListLimitValuesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLimitValuesRequest.Builder>, ListLimitValuesRequest>(){

            @Override
            public ListLimitValuesRequest apply(RequestBuilderAndToken<ListLimitValuesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLimitValuesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLimitValuesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLimitValuesRequest, ListLimitValuesResponse>(){

            @Override
            public ListLimitValuesResponse apply(ListLimitValuesRequest request) {
                return LimitsPaginators.this.client.listLimitValues(request);
            }
        }, (Function)new Function<ListLimitValuesResponse, List<LimitValueSummary>>(){

            @Override
            public List<LimitValueSummary> apply(ListLimitValuesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListServicesResponse> listServicesResponseIterator(final ListServicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListServicesRequest.Builder>(){

            @Override
            public ListServicesRequest.Builder get() {
                return ListServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServicesResponse, String>(){

            @Override
            public String apply(ListServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServicesRequest.Builder>, ListServicesRequest>(){

            @Override
            public ListServicesRequest apply(RequestBuilderAndToken<ListServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServicesRequest, ListServicesResponse>(){

            @Override
            public ListServicesResponse apply(ListServicesRequest request) {
                return LimitsPaginators.this.client.listServices(request);
            }
        });
    }

    public Iterable<ServiceSummary> listServicesRecordIterator(final ListServicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListServicesRequest.Builder>(){

            @Override
            public ListServicesRequest.Builder get() {
                return ListServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServicesResponse, String>(){

            @Override
            public String apply(ListServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServicesRequest.Builder>, ListServicesRequest>(){

            @Override
            public ListServicesRequest apply(RequestBuilderAndToken<ListServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServicesRequest, ListServicesResponse>(){

            @Override
            public ListServicesResponse apply(ListServicesRequest request) {
                return LimitsPaginators.this.client.listServices(request);
            }
        }, (Function)new Function<ListServicesResponse, List<ServiceSummary>>(){

            @Override
            public List<ServiceSummary> apply(ListServicesResponse response) {
                return response.getItems();
            }
        });
    }
}

